/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;
import org.jboss.arquillian.testenricher.osgi.BundleAssociation;
import org.jboss.arquillian.testenricher.osgi.BundleContextAssociation;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;

public class ArquillianBundleActivator
implements BundleActivator {
    private static Logger log = Logger.getLogger(ArquillianBundleActivator.class.getName());
    private JMXTestRunner testRunner;
    private long arqBundleId;

    public void start(BundleContext context) throws Exception {
        this.arqBundleId = context.getBundle().getBundleId();
        final BundleContext syscontext = context.getBundle(0L).getBundleContext();
        final JMXTestRunner.TestClassLoader testClassLoader = new JMXTestRunner.TestClassLoader(){

            public Class<?> loadTestClass(String className) throws ClassNotFoundException {
                String namePath = className.replace('.', '/') + ".class";
                ArrayList<Bundle> bundles = new ArrayList<Bundle>(Arrays.asList(syscontext.getBundles()));
                Iterator iterator = bundles.iterator();
                while (iterator.hasNext()) {
                    Bundle aux = (Bundle)iterator.next();
                    if (aux.getBundleId() > ArquillianBundleActivator.this.arqBundleId && aux.getState() != 1) continue;
                    iterator.remove();
                }
                for (Bundle aux : bundles) {
                    if (aux.getEntry(namePath) == null) continue;
                    return aux.loadClass(className);
                }
                for (Bundle aux : bundles) {
                    String bundlecp = (String)aux.getHeaders().get("Bundle-ClassPath");
                    if (bundlecp == null) continue;
                    try {
                        return aux.loadClass(className);
                    }
                    catch (ClassNotFoundException ex) {
                    }
                }
                throw new ClassNotFoundException("Test '" + className + "' not found in: " + bundles);
            }
        };
        MBeanServer mbeanServer = this.findOrCreateMBeanServer();
        this.testRunner = new JMXTestRunner(testClassLoader){

            public byte[] runTestMethod(String className, String methodName) {
                Class testClass;
                try {
                    testClass = testClassLoader.loadTestClass(className);
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalStateException(ex);
                }
                BundleAssociation.setBundle((Bundle)ArquillianBundleActivator.this.getTestBundle(syscontext, testClass, methodName));
                BundleContextAssociation.setBundleContext((BundleContext)syscontext);
                return super.runTestMethod(className, methodName);
            }
        };
        this.testRunner.registerMBean(mbeanServer);
    }

    public void stop(BundleContext context) throws Exception {
        MBeanServer mbeanServer = this.findOrCreateMBeanServer();
        this.testRunner.unregisterMBean(mbeanServer);
    }

    private MBeanServer findOrCreateMBeanServer() {
        MBeanServer mbeanServer = null;
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            log.warning("Multiple MBeanServer instances: " + serverArr);
        }
        if (serverArr.size() > 0) {
            mbeanServer = serverArr.get(0);
            log.fine("Found MBeanServer: " + mbeanServer.getDefaultDomain());
        }
        if (mbeanServer == null) {
            log.fine("No MBeanServer, create one ...");
            mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return mbeanServer;
    }

    private Bundle getTestBundle(BundleContext syscontext, Class<?> testClass, String methodName) {
        Bundle bundle = ((BundleReference)testClass.getClassLoader()).getBundle();
        block0: for (Method method : testClass.getMethods()) {
            OperateOnDeployment opon = method.getAnnotation(OperateOnDeployment.class);
            if (opon == null || !methodName.equals(method.getName())) continue;
            for (Bundle aux : syscontext.getBundles()) {
                if (!aux.getLocation().equals(opon.value())) continue;
                bundle = aux;
                continue block0;
            }
        }
        return bundle;
    }
}

