/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.container.tomcat.extension;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.ContentCapability;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.utils.IllegalArgumentAssertion;

public final class SharedModuleClassLoader
extends ClassLoader {
    private static final List<URL> urls = new ArrayList<URL>();

    SharedModuleClassLoader(ClassLoader parent) {
        super(SharedModuleClassLoader.getExtendedParent(parent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassLoader getExtendedParent(ClassLoader parent) {
        List<URL> list = urls;
        synchronized (list) {
            if (urls.isEmpty()) {
                return parent;
            }
            URL[] urlarr = urls.toArray(new URL[urls.size()]);
            return new URLClassLoader(urlarr, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSharedModule(Resource resource) {
        URL contentURL = SharedModuleClassLoader.getRequiredContentURL(resource);
        List<URL> list = urls;
        synchronized (list) {
            urls.add(contentURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSharedModule(Resource resource) {
        URL contentURL = SharedModuleClassLoader.getContentURL(resource);
        if (contentURL != null) {
            List<URL> list = urls;
            synchronized (list) {
                urls.remove(contentURL);
            }
        }
    }

    private static URL getContentURL(Resource resource) {
        IllegalArgumentAssertion.assertNotNull((Object)resource, (String)"resource");
        List ccaps = resource.getCapabilities("gravia.content");
        if (ccaps.size() != 1) {
            return null;
        }
        return ((ContentCapability)((Capability)ccaps.get(0)).adapt(ContentCapability.class)).getContentURL();
    }

    private static URL getRequiredContentURL(Resource resource) {
        IllegalArgumentAssertion.assertNotNull((Object)resource, (String)"resource");
        List ccaps = resource.getCapabilities("gravia.content");
        IllegalArgumentAssertion.assertFalse((Boolean)ccaps.isEmpty(), (String)("Cannot obtain content capability from: " + resource));
        IllegalArgumentAssertion.assertFalse((Boolean)(ccaps.size() > 1 ? 1 : 0), (String)("Cannot process multiple content capabilities in: " + resource));
        URL contentURL = ((ContentCapability)((Capability)ccaps.get(0)).adapt(ContentCapability.class)).getContentURL();
        IllegalArgumentAssertion.assertTrue((Boolean)(contentURL != null ? 1 : 0), (String)("Cannot obtain content URL from: " + resource));
        return contentURL;
    }
}

