/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.IdentityHashMap;
import java.util.Iterator;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.helper.ActivateMethod;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.helper.ModifiedMethod;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.ImmediateComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentInstance;

public class ServiceFactoryComponentManager
extends ImmediateComponentManager {
    private IdentityHashMap serviceContexts = new IdentityHashMap();

    public ServiceFactoryComponentManager(BundleComponentActivator activator, ComponentHolder componentHolder, ComponentMetadata metadata, ComponentMethods componentMethods) {
        super(activator, componentHolder, metadata, componentMethods);
    }

    protected boolean createComponent() {
        return true;
    }

    protected void deleteComponent(int reason) {
        if (!this.isWriteLocked()) {
            throw new IllegalStateException("need write lock (deleteComponent)");
        }
        Iterator i = this.serviceContexts.values().iterator();
        while (i.hasNext()) {
            BundleComponentContext componentContext = (BundleComponentContext)i.next();
            i.remove();
            this.disposeImplementationObject(componentContext.getInstance(), componentContext, reason);
            this.log(4, "Unset implementation object for component {0} in deleteComponent", new Object[]{this.getName()}, null);
        }
    }

    Object getInstance() {
        return null;
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        this.log(4, "ServiceFactory.getService()", null);
        try {
            if (!this.collectDependencies()) {
                this.log(3, "getService (ServiceFactory) did not win collecting dependencies, try creating object anyway.", null);
            } else {
                this.log(4, "getService (ServiceFactory) won collecting dependencies, proceed to creating object.", null);
            }
        }
        catch (IllegalStateException e) {
            return null;
        }
        final BundleComponentContext serviceContext = new BundleComponentContext(this, bundle);
        Object service = this.createImplementationObject(serviceContext, new ImmediateComponentManager.SetImplementationObject(){

            public void setImplementationObject(Object implementationObject) {
                serviceContext.setImplementationObject(implementationObject);
                ServiceFactoryComponentManager.this.serviceContexts.put(implementationObject, serviceContext);
                if (ServiceFactoryComponentManager.this.getState() == 32) {
                    ServiceFactoryComponentManager.this.changeState(AbstractComponentManager.Active.getInstance());
                }
            }
        });
        if (service == null) {
            this.log(1, "Failed creating the component instance; see log for reason", null);
        }
        return service;
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        this.log(4, "ServiceFactory.ungetService()", null);
        ComponentContext serviceContext = (ComponentContext)this.serviceContexts.remove(service);
        this.disposeImplementationObject(service, serviceContext, 5);
        if (this.serviceContexts.isEmpty() && this.getState() == 16) {
            this.changeState(AbstractComponentManager.Registered.getInstance());
            this.unsetDependencyMap();
        }
    }

    void update(DependencyManager dependencyManager, ServiceReference ref) {
        for (Object implementationObject : this.serviceContexts.keySet()) {
            dependencyManager.update(implementationObject, ref);
        }
    }

    void invokeBindMethod(DependencyManager dependencyManager, ServiceReference reference) {
        for (Object implementationObject : this.serviceContexts.keySet()) {
            dependencyManager.invokeBindMethod(implementationObject, reference);
        }
    }

    void invokeUnbindMethod(DependencyManager dependencyManager, ServiceReference oldRef) {
        for (Object implementationObject : this.serviceContexts.keySet()) {
            dependencyManager.invokeUnbindMethod(implementationObject, oldRef);
        }
    }

    protected MethodResult invokeModifiedMethod() {
        ModifiedMethod modifiedMethod = this.getComponentMethods().getModifiedMethod();
        MethodResult result = null;
        for (BundleComponentContext componentContext : this.serviceContexts.values()) {
            Object instance = componentContext.getInstance();
            result = modifiedMethod.invoke(instance, new ActivateMethod.ActivatorParameter(componentContext, -1), MethodResult.VOID);
        }
        return result;
    }

    protected boolean hasInstance() {
        return !this.serviceContexts.isEmpty();
    }

    public ComponentInstance getComponentInstance() {
        return super.getComponentInstance();
    }

    private static class BundleComponentContext
    extends ComponentContextImpl {
        private Bundle m_usingBundle;
        private Object m_implementationObject;

        BundleComponentContext(AbstractComponentManager componentManager, Bundle usingBundle) {
            super(componentManager);
            this.m_usingBundle = usingBundle;
        }

        private void setImplementationObject(Object implementationObject) {
            this.m_implementationObject = implementationObject;
        }

        public Bundle getUsingBundle() {
            return this.m_usingBundle;
        }

        public Object getInstance() {
            return this.m_implementationObject;
        }
    }
}

