/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.Reference;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.helper.BindMethods;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.RefPair;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;

public class DependencyManager
implements ServiceListener,
Reference {
    private static final int STATE_MASK = 112;
    private final AbstractComponentManager m_componentManager;
    private final ReferenceMetadata m_dependencyMetadata;
    private final AtomicInteger m_size = new AtomicInteger();
    private BindMethods m_bindMethods;
    private volatile String m_target;
    private volatile Filter m_targetFilter;
    private final Object enableLock = new Object();
    private final Collection<ServiceReference> added = new ArrayList<ServiceReference>();
    private final Collection<ServiceReference> removed = new ArrayList<ServiceReference>();
    private boolean registered;

    DependencyManager(AbstractComponentManager componentManager, ReferenceMetadata dependency) {
        this.m_componentManager = componentManager;
        this.m_dependencyMetadata = dependency;
        if (this.m_componentManager.isLogEnabled(4)) {
            this.m_componentManager.log(4, "Dependency Manager {0} created: interface={1}, filter={2}, policy={3}, cardinality={4}, bind={5}, unbind={6}", new Object[]{this.getName(), dependency.getInterface(), dependency.getTarget(), dependency.getPolicy(), dependency.getCardinality(), dependency.getBind(), dependency.getUnbind()}, null);
        }
    }

    void initBindingMethods(BindMethods bindMethods) {
        this.m_bindMethods = bindMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void serviceChanged(ServiceEvent event) {
        Collection<ServiceReference> collection;
        ServiceReference ref = event.getServiceReference();
        String serviceString = "Service " + this.m_dependencyMetadata.getInterface() + "/" + ref.getProperty("service.id");
        Collection<ServiceReference> changes = null;
        try {
            switch (event.getType()) {
                case 1: {
                    this.m_componentManager.log(4, "Dependency Manager: Adding {0}", new Object[]{serviceString}, null);
                    if (!this.targetFilterMatch(ref)) {
                        this.m_componentManager.log(4, "Dependency Manager: Ignoring added Service for {0} : does not match target filter {1}", new Object[]{this.m_dependencyMetadata.getName(), this.getTarget()}, null);
                        return;
                    }
                    collection = this.added;
                    // MONITORENTER : collection
                    this.added.add(ref);
                    // MONITOREXIT : collection
                    collection = this.enableLock;
                    // MONITORENTER : collection
                    // MONITOREXIT : collection
                    collection = this.added;
                    // MONITORENTER : collection
                    if (!this.added.contains(ref)) {
                        // MONITOREXIT : collection
                        return;
                    }
                    // MONITOREXIT : collection
                    this.m_size.incrementAndGet();
                    changes = this.added;
                    this.serviceAdded(ref);
                    return;
                }
                case 2: {
                    this.m_componentManager.log(4, "Dependency Manager: Updating {0}", new Object[]{serviceString}, null);
                    if (this.getBoundService(ref) == null) {
                        if (!this.targetFilterMatch(ref)) return;
                        collection = this.added;
                        // MONITORENTER : collection
                        this.added.add(ref);
                        // MONITOREXIT : collection
                        collection = this.enableLock;
                        // MONITORENTER : collection
                        // MONITOREXIT : collection
                        collection = this.added;
                        // MONITORENTER : collection
                        if (!this.added.contains(ref)) {
                            // MONITOREXIT : collection
                            return;
                        }
                        // MONITOREXIT : collection
                        changes = this.added;
                        this.m_size.incrementAndGet();
                        if (this.isStatic()) {
                            if (this.m_componentManager.getState() != 4) return;
                            this.m_componentManager.log(4, "Dependency Manager: Service {0} registered, activate component", new Object[]{this.m_dependencyMetadata.getName()}, null);
                            this.m_componentManager.activateInternal();
                            return;
                        }
                        if (!this.isMultiple()) {
                            if (this.isReluctant()) return;
                        }
                        this.serviceAdded(ref);
                        return;
                    }
                    if (this.targetFilterMatch(ref)) {
                        this.m_componentManager.update(this, ref);
                        return;
                    }
                    collection = this.removed;
                    // MONITORENTER : collection
                    this.removed.add(ref);
                    // MONITOREXIT : collection
                    collection = this.enableLock;
                    // MONITORENTER : collection
                    // MONITOREXIT : collection
                    collection = this.removed;
                    // MONITORENTER : collection
                    if (!this.removed.contains(ref)) {
                        // MONITOREXIT : collection
                        return;
                    }
                    // MONITOREXIT : collection
                    changes = this.removed;
                    this.m_size.set(this.getServiceReferenceCount());
                    this.serviceRemoved(ref);
                    return;
                }
                case 4: {
                    this.m_componentManager.log(4, "Dependency Manager: Removing {0}", new Object[]{serviceString}, null);
                    if (!this.targetFilterMatch(ref)) {
                        this.m_componentManager.log(4, "Dependency Manager: Not counting Service for {0} : Service {1} does not match target filter {2}", new Object[]{this.m_dependencyMetadata.getName(), ref.getProperty("service.id"), this.getTarget()}, null);
                        this.serviceRemoved(ref);
                        return;
                    }
                    collection = this.removed;
                    // MONITORENTER : collection
                    this.removed.add(ref);
                    // MONITOREXIT : collection
                    collection = this.enableLock;
                    // MONITORENTER : collection
                    // MONITOREXIT : collection
                    collection = this.removed;
                    // MONITORENTER : collection
                    if (!this.removed.contains(ref)) {
                        // MONITOREXIT : collection
                        return;
                    }
                    // MONITOREXIT : collection
                    changes = this.removed;
                    this.m_size.set(this.getServiceReferenceCount());
                    this.serviceRemoved(ref);
                    return;
                }
            }
            return;
        }
        finally {
            if (changes != null) {
                collection = changes;
            }
        }
    }

    private void serviceAdded(ServiceReference reference) {
        if (this.m_componentManager.getState() == 4 && !this.isOptional()) {
            this.m_componentManager.log(4, "Dependency Manager: Service {0} registered, activate component", new Object[]{this.m_dependencyMetadata.getName()}, null);
            boolean handled = this.m_componentManager.activateInternal();
            if (!handled) {
                this.m_componentManager.log(4, "Dependency Manager: Service {0} activation did not occur on this thread", new Object[]{this.m_dependencyMetadata.getName()}, null);
                Map dependenciesMap = this.m_componentManager.getDependencyMap();
                if (dependenciesMap != null) {
                    Map references = (Map)dependenciesMap.get(this);
                    if (references == null) {
                        throw new IllegalStateException("Allegedly active but dependency manager not represented: " + this);
                    }
                    handled = references.containsKey(reference);
                }
            }
            if (handled) {
                this.m_componentManager.log(4, "Dependency Manager: Service {0} activation on other thread bound service reference {1}", new Object[]{this.m_dependencyMetadata.getName(), reference}, null);
                return;
            }
            this.m_componentManager.log(4, "Dependency Manager: Service {0} activation on other thread: after releasing lock, component instance is: {1}", new Object[]{this.m_dependencyMetadata.getName(), this.m_componentManager.getInstance()}, null);
        }
        if (this.handleServiceEvent()) {
            if (this.m_dependencyMetadata.isStatic()) {
                if (this.m_dependencyMetadata.isReluctant()) {
                    this.m_componentManager.log(4, "Dependency Manager: Added service {0} is ignored for static reluctant reference", new Object[]{this.m_dependencyMetadata.getName()}, null);
                } else {
                    Map bound = (Map)this.m_componentManager.getDependencyMap().get(this);
                    if (this.m_dependencyMetadata.isMultiple() || bound.isEmpty() || reference.compareTo(bound.keySet().iterator().next()) > 0) {
                        this.m_componentManager.deactivateInternal(2, false);
                        this.m_componentManager.activateInternal();
                    }
                }
            } else if (this.m_dependencyMetadata.getBind() != null) {
                Map bound;
                ServiceReference oldRef;
                if (this.m_dependencyMetadata.isMultiple() || !this.isBound()) {
                    this.m_componentManager.invokeBindMethod(this, reference);
                } else if (!this.isReluctant() && reference.compareTo((Object)(oldRef = (ServiceReference)(bound = (Map)this.m_componentManager.getDependencyMap().get(this)).keySet().iterator().next())) > 0) {
                    this.m_componentManager.invokeBindMethod(this, reference);
                    this.m_componentManager.invokeUnbindMethod(this, oldRef);
                }
            }
        } else {
            this.m_componentManager.log(4, "Dependency Manager: Ignoring service addition, wrong state {0}", new Object[]{this.m_componentManager.state()}, null);
        }
    }

    private void serviceRemoved(ServiceReference reference) {
        if (!this.isSatisfied()) {
            this.m_componentManager.log(4, "Dependency Manager: Deactivating component due to mandatory dependency on {0}/{1} not satisfied", new Object[]{this.m_dependencyMetadata.getName(), this.m_dependencyMetadata.getInterface()}, null);
            this.m_componentManager.deactivateInternal(2, false);
        }
        if (this.getBoundService(reference) == null) {
            this.m_componentManager.log(4, "Dependency Manager: Ignoring removed Service for {0} : Service {1} not bound", new Object[]{this.m_dependencyMetadata.getName(), reference.getProperty("service.id")}, null);
        } else if (this.handleServiceEvent() || (this.m_componentManager.getState() & 0x101) != 0) {
            Map dependencyMap = this.m_componentManager.getDependencyMap();
            Map referenceMap = null;
            if (dependencyMap != null) {
                referenceMap = (Map)dependencyMap.get(this);
            }
            if (this.m_dependencyMetadata.isStatic()) {
                try {
                    this.m_componentManager.log(4, "Dependency Manager: Static dependency on {0}/{1} is broken", new Object[]{this.m_dependencyMetadata.getName(), this.m_dependencyMetadata.getInterface()}, null);
                    this.m_componentManager.deactivateInternal(2, false);
                    if (referenceMap != null) {
                        referenceMap.remove(reference);
                    }
                    this.m_componentManager.activateInternal();
                }
                catch (Exception ex) {
                    this.m_componentManager.log(1, "Exception while recreating dependency ", ex);
                }
            } else {
                if (!this.m_dependencyMetadata.isMultiple()) {
                    ServiceReference ref = this.getFrameworkServiceReference();
                    if (ref == null) {
                        if (!this.m_dependencyMetadata.isOptional()) {
                            this.m_componentManager.log(4, "Dependency Manager: Deactivating component due to mandatory dependency on {0}/{1} not satisfied", new Object[]{this.m_dependencyMetadata.getName(), this.m_dependencyMetadata.getInterface()}, null);
                            this.m_componentManager.deactivateInternal(2, false);
                        }
                    } else {
                        this.m_componentManager.invokeBindMethod(this, ref);
                    }
                }
                if (this.m_dependencyMetadata.getUnbind() != null) {
                    this.m_componentManager.invokeUnbindMethod(this, reference);
                }
                this.ungetService(reference);
                if (referenceMap != null) {
                    referenceMap.remove(reference);
                }
            }
        } else {
            this.m_componentManager.log(4, "Dependency Manager: Ignoring service removal, wrong state {0}", new Object[]{this.m_componentManager.state()}, null);
        }
    }

    private boolean handleServiceEvent() {
        return (this.m_componentManager.getState() & 0x70) != 0;
    }

    public String getServiceName() {
        return this.m_dependencyMetadata.getInterface();
    }

    public ServiceReference[] getServiceReferences() {
        return this.getBoundServiceReferences();
    }

    public boolean isOptional() {
        return this.m_dependencyMetadata.isOptional();
    }

    public boolean isMultiple() {
        return this.m_dependencyMetadata.isMultiple();
    }

    public boolean isStatic() {
        return this.m_dependencyMetadata.isStatic();
    }

    public boolean isReluctant() {
        return this.m_dependencyMetadata.isReluctant();
    }

    public String getBindMethodName() {
        return this.m_dependencyMetadata.getBind();
    }

    public String getUnbindMethodName() {
        return this.m_dependencyMetadata.getUnbind();
    }

    public String getUpdatedMethodName() {
        return this.m_dependencyMetadata.getUpdated();
    }

    void enable() throws InvalidSyntaxException {
        if (this.hasGetPermission()) {
            this.setTargetFilter(this.m_dependencyMetadata.getTarget());
            this.m_componentManager.log(4, "Registered for service events, currently {0} service(s) match the filter", new Object[]{new Integer(this.m_size.get())}, null);
        } else {
            this.m_size.set(0);
            this.m_componentManager.log(4, "Not registered for service events since the bundle has no permission to get service {0}", new Object[]{this.m_dependencyMetadata.getInterface()}, null);
        }
    }

    void deactivate() {
        ServiceReference[] boundRefs;
        if (this.m_componentManager.getDependencyMap() != null && (boundRefs = this.getBoundServiceReferences()) != null) {
            for (int i = 0; i < boundRefs.length; ++i) {
                this.ungetService(boundRefs[i]);
            }
        }
    }

    int size() {
        return this.m_size.get();
    }

    ServiceReference[] getFrameworkServiceReferences() {
        return this.getFrameworkServiceReferences(this.getTarget());
    }

    private ServiceReference[] getFrameworkServiceReferences(String targetFilter) {
        if (this.hasGetPermission()) {
            BundleComponentActivator bca = this.m_componentManager.getActivator();
            if (bca == null) {
                return null;
            }
            BundleContext bc = bca.getBundleContext();
            if (bc == null) {
                return null;
            }
            try {
                return bc.getServiceReferences(this.m_dependencyMetadata.getInterface(), targetFilter);
            }
            catch (IllegalStateException ise) {
            }
            catch (InvalidSyntaxException ise) {
                this.m_componentManager.log(1, "Unexpected problem with filter ''{0}''", new Object[]{targetFilter}, ise);
                return null;
            }
        }
        this.m_componentManager.log(4, "No permission to access the services", null);
        return null;
    }

    private int getServiceReferenceCount() {
        ServiceReference[] refs = this.getFrameworkServiceReferences();
        return refs == null ? 0 : refs.length;
    }

    ServiceReference getFrameworkServiceReference() {
        ServiceReference[] refs = this.getFrameworkServiceReferences();
        if (refs == null) {
            return null;
        }
        if (refs.length == 1) {
            return refs[0];
        }
        ServiceReference selectedRef = refs[0];
        for (int i = 1; i < refs.length; ++i) {
            ServiceReference ref = refs[i];
            if (ref.compareTo((Object)selectedRef) <= 0) continue;
            selectedRef = ref;
        }
        return selectedRef;
    }

    Object getService() {
        ServiceReference sr = this.getFrameworkServiceReference();
        return sr != null ? this.getService(sr) : null;
    }

    Object[] getServices() {
        ServiceReference[] sr = this.getFrameworkServiceReferences();
        if (sr == null || sr.length == 0) {
            return null;
        }
        ArrayList<Object> services = new ArrayList<Object>();
        for (int i = 0; i < sr.length; ++i) {
            Object service = this.getService(sr[i]);
            if (service == null) continue;
            services.add(service);
        }
        return services.size() > 0 ? services.toArray() : null;
    }

    public ServiceReference[] getBoundServiceReferences() {
        Map dependencyMap = this.m_componentManager.getDependencyMap();
        if (dependencyMap == null) {
            return null;
        }
        Map bound = (Map)dependencyMap.get(this);
        if (bound.isEmpty()) {
            return null;
        }
        return bound.keySet().toArray(new ServiceReference[bound.size()]);
    }

    private boolean isBound() {
        Map dependencyMap = this.m_componentManager.getDependencyMap();
        if (dependencyMap == null) {
            return false;
        }
        Map bound = (Map)dependencyMap.get(this);
        return !bound.isEmpty();
    }

    private RefPair getBoundService(ServiceReference serviceReference) {
        Map dependencyMap = this.m_componentManager.getDependencyMap();
        if (dependencyMap == null) {
            return null;
        }
        return (RefPair)((Map)dependencyMap.get(this)).get(serviceReference);
    }

    Object getService(ServiceReference serviceReference) {
        RefPair refPair = this.getBoundService(serviceReference);
        if (refPair != null && refPair.getServiceObject() != null) {
            return refPair.getServiceObject();
        }
        Object serviceObject = null;
        try {
            serviceObject = this.m_componentManager.getActivator().getBundleContext().getService(serviceReference);
        }
        catch (Exception e) {
            this.m_componentManager.log(1, "Failed getting service {0} ({1}/{2,number,#})", new Object[]{this.m_dependencyMetadata.getName(), this.m_dependencyMetadata.getInterface(), serviceReference.getProperty("service.id")}, e);
            return null;
        }
        if (serviceObject != null) {
            if (refPair != null) {
                refPair.setServiceObject(serviceObject);
            } else {
                refPair = new RefPair(serviceReference);
                refPair.setServiceObject(serviceObject);
                ((Map)this.m_componentManager.getDependencyMap().get(this)).put(serviceReference, refPair);
            }
        }
        return serviceObject;
    }

    void ungetService(ServiceReference serviceReference) {
        BundleContext bundleContext;
        BundleComponentActivator activator;
        RefPair refPair;
        Map dependencyMap = this.m_componentManager.getDependencyMap();
        if (dependencyMap != null && (refPair = (RefPair)((Map)dependencyMap.get(this)).get(serviceReference)) != null && refPair.getServiceObject() != null && (activator = this.m_componentManager.getActivator()) != null && (bundleContext = activator.getBundleContext()) != null) {
            try {
                bundleContext.ungetService(serviceReference);
            }
            catch (IllegalStateException e) {
                this.m_componentManager.log(3, "For dependency {0}, trying to unget ServiceReference {1} on invalid bundle context {2}", new Object[]{this.m_dependencyMetadata.getName(), serviceReference.getProperty("service.id"), serviceReference}, null);
            }
        }
    }

    public String getName() {
        return this.m_dependencyMetadata.getName();
    }

    public boolean isSatisfied() {
        return this.size() > 0 || this.m_dependencyMetadata.isOptional();
    }

    public boolean hasGetPermission() {
        if (System.getSecurityManager() != null) {
            ServicePermission perm = new ServicePermission(this.getServiceName(), "get");
            return this.m_componentManager.getBundle().hasPermission((Object)perm);
        }
        return true;
    }

    boolean open(Object componentInstance, Map parameters) {
        return this.bind(componentInstance, parameters);
    }

    void close(Object componentInstance) {
        this.unbind(componentInstance, this.getBoundServiceReferences());
    }

    boolean prebind(Map dependencyMap) {
        if (!this.isSatisfied()) {
            return false;
        }
        if (this.m_dependencyMetadata.getBind() == null) {
            dependencyMap.put(this, new HashMap());
            return true;
        }
        HashMap<ServiceReference, RefPair> result = new HashMap<ServiceReference, RefPair>();
        boolean success = this.m_dependencyMetadata.isOptional();
        if (this.m_dependencyMetadata.isMultiple()) {
            ServiceReference[] refs = this.getFrameworkServiceReferences();
            if (refs != null) {
                for (int index = 0; index < refs.length; ++index) {
                    RefPair refPair = new RefPair(refs[index]);
                    if (this.m_bindMethods.getBind().getServiceObject(refPair, this.m_componentManager.getActivator().getBundleContext())) {
                        result.put(refs[index], refPair);
                        success = true;
                        continue;
                    }
                    this.m_componentManager.getActivator().registerMissingDependency(this, refs[index]);
                }
            }
        } else {
            ServiceReference ref = this.getFrameworkServiceReference();
            if (ref != null) {
                RefPair refPair = new RefPair(ref);
                if (this.m_bindMethods.getBind().getServiceObject(refPair, this.m_componentManager.getActivator().getBundleContext())) {
                    result.put(ref, refPair);
                    success = true;
                } else if (this.isOptional()) {
                    this.m_componentManager.getActivator().registerMissingDependency(this, ref);
                }
            }
        }
        dependencyMap.put(this, result);
        return success;
    }

    private boolean bind(Object componentInstance, Map parameters) {
        if (!this.isSatisfied()) {
            this.m_componentManager.log(4, "For dependency {0}, no longer satisfied, bind fails", new Object[]{this.m_dependencyMetadata.getName()}, null);
            return false;
        }
        if (componentInstance == null || this.m_dependencyMetadata.getBind() == null) {
            return true;
        }
        boolean success = this.m_dependencyMetadata.isOptional();
        this.m_componentManager.log(4, "For dependency {0}, optional: {1}; to bind: {2}", new Object[]{this.m_dependencyMetadata.getName(), new Boolean(success), parameters}, null);
        for (Map.Entry entry : parameters.entrySet()) {
            if (!this.invokeBindMethod(componentInstance, (RefPair)entry.getValue())) {
                this.m_componentManager.log(4, "For dependency {0}, failed to invoke bind method on object {1}", new Object[]{this.m_dependencyMetadata.getName(), entry.getValue()}, null);
            }
            success = true;
        }
        return success;
    }

    void update(Object componentInstance, ServiceReference ref) {
        if (this.m_dependencyMetadata.getUpdated() != null) {
            this.invokeUpdatedMethod(componentInstance, ref);
        }
    }

    private void unbind(Object componentInstance, ServiceReference[] boundRefs) {
        if (boundRefs != null) {
            boolean doUnbind = componentInstance != null && this.m_dependencyMetadata.getUnbind() != null;
            for (int i = 0; i < boundRefs.length; ++i) {
                if (doUnbind) {
                    this.invokeUnbindMethod(componentInstance, boundRefs[i]);
                }
                this.ungetService(boundRefs[i]);
            }
        }
    }

    boolean invokeBindMethod(Object componentInstance, ServiceReference ref) {
        if (componentInstance != null) {
            Map dependencyMap = this.m_componentManager.getDependencyMap();
            if (dependencyMap != null) {
                if (this.m_bindMethods == null) {
                    this.m_componentManager.log(1, "For dependency {0}, bind method not set: component state {1}", new Object[]{this.m_dependencyMetadata.getName(), new Integer(this.m_componentManager.getState())}, null);
                }
                Map deps = (Map)dependencyMap.get(this);
                RefPair refPair = new RefPair(ref);
                if (!this.m_bindMethods.getBind().getServiceObject(refPair, this.m_componentManager.getActivator().getBundleContext())) {
                    return false;
                }
                deps.put(ref, refPair);
                return this.invokeBindMethod(componentInstance, refPair);
            }
            return false;
        }
        this.m_componentManager.log(4, "DependencyManager : component not yet created, assuming bind method call succeeded", null);
        return true;
    }

    public void invokeBindMethodLate(ServiceReference ref) {
        if (!this.isSatisfied()) {
            return;
        }
        if (!this.isMultiple()) {
            ServiceReference[] refs = this.getFrameworkServiceReferences();
            if (refs == null) {
                return;
            }
            for (int i = 1; i < refs.length; ++i) {
                ServiceReference test = refs[i];
                if (test.compareTo((Object)ref) <= 0) continue;
                return;
            }
        }
        this.m_componentManager.invokeBindMethod(this, ref);
    }

    private boolean invokeBindMethod(Object componentInstance, RefPair refPair) {
        if (componentInstance != null) {
            if (this.m_bindMethods != null) {
                MethodResult result = this.m_bindMethods.getBind().invoke(componentInstance, refPair, MethodResult.VOID);
                if (result == null) {
                    return false;
                }
                this.m_componentManager.setServiceProperties(result);
                return true;
            }
            this.m_componentManager.log(3, "DependencyManager : Component instance present, but DependencyManager shut down (no bind method)", null);
            return false;
        }
        this.m_componentManager.log(4, "DependencyManager : component not yet created, assuming bind method call succeeded", null);
        return true;
    }

    private void invokeUpdatedMethod(Object componentInstance, ServiceReference ref) {
        if (componentInstance != null) {
            RefPair refPair = (RefPair)((Map)this.m_componentManager.getDependencyMap().get(this)).get(ref);
            if (refPair == null) {
                this.m_componentManager.log(2, "DependencyManager : invokeUpdatedMethod : Component set, but reference not present", null);
                return;
            }
            if (!this.m_bindMethods.getUpdated().getServiceObject(refPair, this.m_componentManager.getActivator().getBundleContext())) {
                this.m_componentManager.log(2, "DependencyManager : invokeUpdatedMethod : Service not available from service registry for ServiceReference {0} for reference {1}", new Object[]{ref, this.getName()}, null);
                return;
            }
            MethodResult methodResult = this.m_bindMethods.getUpdated().invoke(componentInstance, refPair, MethodResult.VOID);
            if (methodResult != null) {
                this.m_componentManager.setServiceProperties(methodResult);
            }
        } else {
            this.m_componentManager.log(4, "DependencyManager : Component not set, no need to call updated method", null);
        }
    }

    void invokeUnbindMethod(Object componentInstance, ServiceReference ref) {
        if (componentInstance != null) {
            RefPair refPair = (RefPair)((Map)this.m_componentManager.getDependencyMap().get(this)).get(ref);
            if (refPair == null) {
                this.m_componentManager.log(2, "DependencyManager : invokeUnbindMethod : Component set, but reference not present", null);
                return;
            }
            if (!this.m_bindMethods.getUnbind().getServiceObject(refPair, this.m_componentManager.getActivator().getBundleContext())) {
                this.m_componentManager.log(2, "DependencyManager : invokeUnbindMethod : Service not available from service registry for ServiceReference {0} for reference {1}", new Object[]{ref, this.getName()}, null);
                return;
            }
            MethodResult methodResult = this.m_bindMethods.getUnbind().invoke(componentInstance, refPair, MethodResult.VOID);
            if (methodResult != null) {
                this.m_componentManager.setServiceProperties(methodResult);
            }
        } else {
            this.m_componentManager.log(4, "DependencyManager : Component not set, no need to call unbind method", null);
        }
    }

    boolean canUpdateDynamically(Dictionary properties) {
        String newTarget = (String)properties.get(this.m_dependencyMetadata.getTargetPropertyName());
        String currentTarget = this.getTarget();
        if (currentTarget == null && newTarget == null || currentTarget != null && currentTarget.equals(newTarget)) {
            return true;
        }
        if (this.m_dependencyMetadata.isStatic()) {
            return false;
        }
        ServiceReference[] refs = this.getFrameworkServiceReferences(newTarget);
        if (refs != null && refs.length > 0) {
            return true;
        }
        return this.m_dependencyMetadata.isOptional();
    }

    void setTargetFilter(Dictionary properties) {
        try {
            this.setTargetFilter((String)properties.get(this.m_dependencyMetadata.getTargetPropertyName()));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTargetFilter(String target) throws InvalidSyntaxException {
        if (this.m_target == null && target == null || this.m_target != null && this.m_target.equals(target)) {
            this.m_componentManager.log(4, "No change in target property for dependency {0}: currently registered: {1}", new Object[]{this.m_dependencyMetadata.getName(), this.registered}, null);
            if (this.registered) {
                return;
            }
        }
        this.m_target = target;
        if (this.registered) {
            this.unregisterServiceListener();
        }
        if (target != null) {
            this.m_componentManager.log(4, "Setting target property for dependency {0} to {1}", new Object[]{this.m_dependencyMetadata.getName(), target}, null);
            try {
                this.m_targetFilter = this.m_componentManager.getActivator().getBundleContext().createFilter(target);
            }
            catch (InvalidSyntaxException ise) {
                this.m_componentManager.log(1, "Invalid syntax in target property for dependency {0} to {1}", new Object[]{this.m_dependencyMetadata.getName(), target}, null);
                this.m_targetFilter = null;
            }
        } else {
            this.m_componentManager.log(4, "Clearing target property for dependency {0}", new Object[]{this.m_dependencyMetadata.getName()}, null);
            this.m_targetFilter = null;
        }
        Collection<ServiceReference> ise = this.added;
        synchronized (ise) {
            while (!this.added.isEmpty()) {
                try {
                    this.added.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        ise = this.removed;
        synchronized (ise) {
            while (!this.removed.isEmpty()) {
                try {
                    this.removed.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        ServiceReference[] boundRefs = this.getBoundServiceReferences();
        if (boundRefs != null && this.m_targetFilter != null) {
            for (ServiceReference boundRef : boundRefs) {
                if (this.m_targetFilter.match(boundRef)) continue;
                this.serviceRemoved(boundRef);
            }
        }
        boolean active = this.m_componentManager.getDependencyMap() != null;
        this.registerServiceListener();
        ArrayList<ServiceReference> toAdd = new ArrayList<ServiceReference>();
        Iterator i$ = this.enableLock;
        synchronized (i$) {
            ServiceReference[] refArray = this.getFrameworkServiceReferences();
            if (refArray != null) {
                List<ServiceReference> refs = Arrays.asList(refArray);
                this.m_componentManager.log(4, "Component: {0} dependency: {1} refs: {2}", new Object[]{this.m_componentManager.getName(), this.getName(), refs}, null);
                Collection<ServiceReference> collection = this.added;
                synchronized (collection) {
                    this.m_componentManager.log(4, "Component: {0} dependency: {1} added: {2}", new Object[]{this.m_componentManager.getName(), this.getName(), this.added}, null);
                    this.added.removeAll(refs);
                }
                collection = this.removed;
                synchronized (collection) {
                    this.m_componentManager.log(4, "Component: {0} dependency: {1} removed: {2}", new Object[]{this.m_componentManager.getName(), this.getName(), this.removed}, null);
                    this.removed.retainAll(refs);
                }
                if (active) {
                    for (ServiceReference ref : refs) {
                        if (this.getBoundService(ref) != null) continue;
                        toAdd.add(ref);
                    }
                }
            } else {
                this.m_componentManager.log(4, "Component: {0} dependency: {1} no services", new Object[]{this.m_componentManager.getName(), this.getName()}, null);
                this.removed.clear();
            }
            this.m_size.set(refArray == null ? 0 : refArray.length);
        }
        for (ServiceReference ref : toAdd) {
            this.serviceAdded(ref);
        }
    }

    private void registerServiceListener() throws InvalidSyntaxException {
        String filterString = "(objectClass=" + this.m_dependencyMetadata.getInterface() + ")";
        this.m_componentManager.getActivator().getBundleContext().addServiceListener((ServiceListener)this, filterString);
        this.registered = true;
        this.m_componentManager.log(4, "registering service listener for dependency {0}", new Object[]{this.m_dependencyMetadata.getName()}, null);
    }

    void unregisterServiceListener() {
        this.m_componentManager.getActivator().getBundleContext().removeServiceListener((ServiceListener)this);
        this.registered = false;
        this.m_componentManager.log(4, "unregistering service listener for dependency {0}", new Object[]{this.m_dependencyMetadata.getName()}, null);
    }

    public String getTarget() {
        return this.m_target;
    }

    private boolean targetFilterMatch(ServiceReference ref) {
        return this.m_targetFilter == null || this.m_targetFilter.match(ref);
    }

    public String toString() {
        return "DependencyManager: Component [" + this.m_componentManager + "] reference [" + this.m_dependencyMetadata.getName() + "]";
    }
}

