/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.config;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.manager.DelayedComponentManager;
import org.apache.felix.scr.impl.manager.ImmediateComponentManager;
import org.apache.felix.scr.impl.manager.ServiceFactoryComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;

public class ImmediateComponentHolder
implements ComponentHolder,
SimpleLogger {
    private final BundleComponentActivator m_activator;
    private final ComponentMetadata m_componentMetadata;
    private final Map m_components;
    private ImmediateComponentManager m_singleComponent;
    private boolean m_enabled;
    private final ComponentMethods m_componentMethods;

    public ImmediateComponentHolder(BundleComponentActivator activator, ComponentMetadata metadata) {
        this.m_activator = activator;
        this.m_componentMetadata = metadata;
        this.m_components = new HashMap();
        this.m_componentMethods = new ComponentMethods();
        this.m_singleComponent = this.createComponentManager();
        this.m_enabled = false;
    }

    protected ImmediateComponentManager createComponentManager() {
        ImmediateComponentManager manager;
        if (this.m_componentMetadata.isFactory()) {
            throw new IllegalArgumentException("Cannot create component factory for " + this.m_componentMetadata.getName());
        }
        if (this.m_componentMetadata.isImmediate()) {
            manager = new ImmediateComponentManager(this.m_activator, this, this.m_componentMetadata, this.m_componentMethods);
        } else if (this.m_componentMetadata.getServiceMetadata() != null) {
            manager = this.m_componentMetadata.getServiceMetadata().isServiceFactory() ? new ServiceFactoryComponentManager(this.m_activator, this, this.m_componentMetadata, this.m_componentMethods) : new DelayedComponentManager(this.m_activator, this, this.m_componentMetadata, this.m_componentMethods);
        } else {
            throw new IllegalArgumentException("Cannot create a component manager for " + this.m_componentMetadata.getName());
        }
        return manager;
    }

    public final BundleComponentActivator getActivator() {
        return this.m_activator;
    }

    public final ComponentMetadata getComponentMetadata() {
        return this.m_componentMetadata;
    }

    public void configurationDeleted(String pid) {
        if (this.m_singleComponent == null) {
            return;
        }
        if (pid.equals(this.getComponentMetadata().getConfigurationPid())) {
            this.m_singleComponent.reconfigure(null);
        } else {
            ImmediateComponentManager icm = this.removeComponentManager(pid);
            if (icm != null) {
                boolean dispose = true;
                if (this.m_singleComponent == icm) {
                    if (this.m_components.isEmpty()) {
                        icm.reconfigure(null);
                        dispose = false;
                    } else {
                        this.m_singleComponent = (ImmediateComponentManager)this.m_components.values().iterator().next();
                    }
                }
                if (dispose) {
                    icm.disposeInternal(4);
                }
            }
        }
    }

    public void configurationUpdated(String pid, Dictionary props) {
        this.log(4, "ImmediateComponentHolder configuration updated for pid {0} with properties {1}", new Object[]{pid, props}, null);
        if (this.m_singleComponent == null) {
            return;
        }
        if (pid.equals(this.getComponentMetadata().getConfigurationPid())) {
            this.log(4, "ImmediateComponentHolder reconfiguring single component for pid {0} ", new Object[]{pid}, null);
            this.m_singleComponent.reconfigure(props);
        } else {
            ImmediateComponentManager icm = this.getComponentManager(pid);
            if (icm != null) {
                this.log(4, "ImmediateComponentHolder reconfiguring existing component for pid {0} ", new Object[]{pid}, null);
                icm.reconfigure(props);
            } else {
                ImmediateComponentManager newIcm;
                if (!this.m_singleComponent.hasConfiguration()) {
                    this.log(4, "ImmediateComponentHolder configuring the unconfigured single component for pid {0} ", new Object[]{pid}, null);
                    newIcm = this.m_singleComponent;
                } else {
                    this.log(4, "ImmediateComponentHolder configuring a new component for pid {0} ", new Object[]{pid}, null);
                    newIcm = this.createComponentManager();
                }
                newIcm.reconfigure(props);
                if (this.m_enabled && this.getComponentMetadata().isEnabled()) {
                    newIcm.enable(false);
                }
                this.putComponentManager(pid, newIcm);
            }
        }
    }

    public Component[] getComponents() {
        Component[] componentArray;
        Component[] components = this.getComponentManagers(false);
        if (components != null) {
            componentArray = components;
        } else {
            Component[] componentArray2 = new Component[1];
            componentArray = componentArray2;
            componentArray2[0] = this.m_singleComponent;
        }
        return componentArray;
    }

    public void enableComponents(boolean async) {
        ImmediateComponentManager[] cms = this.getComponentManagers(false);
        if (cms == null) {
            this.m_singleComponent.enable(async);
        } else {
            for (int i = 0; i < cms.length; ++i) {
                cms[i].enable(async);
            }
        }
        this.m_enabled = true;
    }

    public void disableComponents(boolean async) {
        this.m_enabled = false;
        ImmediateComponentManager[] cms = this.getComponentManagers(false);
        if (cms == null) {
            this.m_singleComponent.disable(async);
        } else {
            for (int i = 0; i < cms.length; ++i) {
                cms[i].disable(async);
            }
        }
    }

    public void disposeComponents(int reason) {
        ImmediateComponentManager singleComponent = this.m_singleComponent;
        this.m_singleComponent = null;
        ImmediateComponentManager[] cms = this.getComponentManagers(true);
        if (cms == null) {
            singleComponent.dispose(reason);
        } else {
            for (int i = 0; i < cms.length; ++i) {
                cms[i].dispose(reason);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposed(ImmediateComponentManager component) {
        Map map = this.m_components;
        synchronized (map) {
            if (!this.m_components.isEmpty()) {
                Iterator vi = this.m_components.values().iterator();
                while (vi.hasNext()) {
                    if (component != vi.next()) continue;
                    vi.remove();
                    break;
                }
            }
        }
        if (component == this.m_singleComponent) {
            map = this.m_components;
            synchronized (map) {
                this.m_singleComponent = this.m_components.isEmpty() ? this.createComponentManager() : (ImmediateComponentManager)this.m_components.values().iterator().next();
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ImmediateComponentHolder)) {
            return false;
        }
        ImmediateComponentHolder other = (ImmediateComponentHolder)object;
        return this.getComponentMetadata().getName().equals(other.getComponentMetadata().getName());
    }

    public int hashCode() {
        return this.getComponentMetadata().getName().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmediateComponentManager getComponentManager(String pid) {
        Map map = this.m_components;
        synchronized (map) {
            return (ImmediateComponentManager)this.m_components.get(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmediateComponentManager removeComponentManager(String pid) {
        Map map = this.m_components;
        synchronized (map) {
            return (ImmediateComponentManager)this.m_components.remove(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putComponentManager(String pid, ImmediateComponentManager componentManager) {
        Map map = this.m_components;
        synchronized (map) {
            this.m_components.put(pid, componentManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmediateComponentManager[] getComponentManagers(boolean clear) {
        Map map = this.m_components;
        synchronized (map) {
            if (this.m_components.isEmpty()) {
                return null;
            }
            ImmediateComponentManager[] cm = new ImmediateComponentManager[this.m_components.size()];
            this.m_components.values().toArray(cm);
            if (clear) {
                this.m_components.clear();
            }
            return cm;
        }
    }

    public boolean isLogEnabled(int level) {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            return activator.isLogEnabled(level);
        }
        return false;
    }

    public void log(int level, String message, Throwable ex) {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            activator.log(level, message, this.getComponentMetadata(), ex);
        }
    }

    public void log(int level, String message, Object[] arguments, Throwable ex) {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            activator.log(level, message, arguments, this.getComponentMetadata(), ex);
        }
    }
}

