/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceReference;

public class ReadOnlyDictionary
extends Dictionary
implements Map {
    private final Hashtable m_delegatee;

    public ReadOnlyDictionary(Dictionary delegatee) {
        if (delegatee instanceof Hashtable) {
            this.m_delegatee = (Hashtable)delegatee;
        } else {
            this.m_delegatee = new Hashtable();
            Enumeration ke = delegatee.elements();
            while (ke.hasMoreElements()) {
                Object key = ke.nextElement();
                this.m_delegatee.put(key, delegatee.get(key));
            }
        }
    }

    public ReadOnlyDictionary(ServiceReference serviceReference) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] keys = serviceReference.getPropertyKeys();
        if (keys != null) {
            for (int j = 0; j < keys.length; ++j) {
                String key = keys[j];
                properties.put(key, serviceReference.getProperty(key));
            }
        }
        this.m_delegatee = properties;
    }

    public Enumeration elements() {
        return this.m_delegatee.elements();
    }

    public Object get(Object key) {
        return this.m_delegatee.get(key);
    }

    public boolean isEmpty() {
        return this.m_delegatee.isEmpty();
    }

    public Enumeration keys() {
        return this.m_delegatee.keys();
    }

    public Object put(Object key, Object value) {
        return null;
    }

    public Object remove(Object key) {
        return null;
    }

    public int size() {
        return this.m_delegatee.size();
    }

    public String toString() {
        return this.m_delegatee.toString();
    }

    public void clear() {
    }

    public boolean containsKey(Object key) {
        return this.m_delegatee.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.m_delegatee.containsValue(value);
    }

    public Set entrySet() {
        return Collections.unmodifiableSet(this.m_delegatee.entrySet());
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.m_delegatee.keySet());
    }

    public void putAll(Map m) {
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this.m_delegatee.values());
    }
}

