/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.embedded.internal;

import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.utils.NotNullException;

class ClassLoaderEntriesProvider
implements ModuleEntriesProvider {
    private final ClassLoader classLoader;

    ClassLoaderEntriesProvider(Module module) {
        NotNullException.assertValue((Object)module, (String)"module");
        this.classLoader = (ClassLoader)module.adapt(ClassLoader.class);
    }

    public URL getEntry(String path) {
        return this.classLoader.getResource(path);
    }

    public Enumeration<String> getEntryPaths(String path) {
        throw new UnsupportedOperationException("Bundle.getEntryPaths(String)");
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        if (filePattern.contains("*") || recurse) {
            throw new UnsupportedOperationException("Bundle.getEntryPaths(String,String,boolean)");
        }
        URL result = this.classLoader.getResource(path + "/" + filePattern);
        if (result == null) {
            return null;
        }
        Vector<URL> vector = new Vector<URL>();
        vector.add(result);
        return vector.elements();
    }
}

