/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.RuntimeFactory;
import org.jboss.gravia.runtime.spi.RuntimeLogger;
import org.jboss.gravia.utils.NotNullException;

public final class RuntimeLocator {
    private static AtomicReference<Runtime> runtimeReference = new AtomicReference();

    private RuntimeLocator() {
    }

    public static Runtime getRuntime() {
        return runtimeReference.get();
    }

    public static Runtime getRequiredRuntime() {
        Runtime runtime = runtimeReference.get();
        if (runtime == null) {
            throw new IllegalStateException("Runtime not available from: " + RuntimeLocator.class.getClassLoader());
        }
        return runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Runtime createRuntime(RuntimeFactory factory, PropertiesProvider props) {
        NotNullException.assertValue((Object)factory, (String)"factory");
        NotNullException.assertValue((Object)props, (String)"props");
        AtomicReference<Runtime> atomicReference = runtimeReference;
        synchronized (atomicReference) {
            Runtime runtime = runtimeReference.get();
            if (runtime != null) {
                throw new IllegalStateException("Runtime already created: " + runtime);
            }
            runtime = factory.createRuntime(props);
            runtimeReference.set(runtime);
            RuntimeLogger.LOGGER.info("Runtime created: {}", (Object)runtime);
            return runtime;
        }
    }

    public static Runtime createRuntime(PropertiesProvider props) {
        NotNullException.assertValue((Object)props, (String)"props");
        RuntimeFactory factory = null;
        String className = (String)props.getProperty(RuntimeFactory.class.getName());
        if (className != null) {
            try {
                factory = (RuntimeFactory)Class.forName(className).newInstance();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot load runtime factory: " + className, ex);
            }
        } else {
            ServiceLoader<RuntimeFactory> loader = ServiceLoader.load(RuntimeFactory.class, RuntimeLocator.class.getClassLoader());
            Iterator<RuntimeFactory> iterator = loader.iterator();
            if (iterator.hasNext()) {
                factory = iterator.next();
            }
        }
        return RuntimeLocator.createRuntime(factory, props);
    }

    public static void releaseRuntime() {
        Runtime runtime = runtimeReference.getAndSet(null);
        if (runtime != null) {
            RuntimeLogger.LOGGER.info("Runtime released: {}", (Object)runtime);
        }
    }
}

