/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource.spi;

import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.MavenCoordinates;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceBuilder;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.Version;
import org.jboss.gravia.resource.VersionRange;
import org.jboss.gravia.resource.spi.AbstractCapability;
import org.jboss.gravia.resource.spi.AbstractRequirement;
import org.jboss.gravia.resource.spi.AbstractResource;
import org.jboss.gravia.resource.spi.AttributeValueHandler;
import org.jboss.gravia.resource.spi.ElementParser;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.jboss.gravia.utils.MavenUtils;

public abstract class AbstractResourceBuilder
implements ResourceBuilder {
    private AbstractResource resource;

    protected abstract AbstractResource createResource();

    protected abstract AbstractCapability createCapability(AbstractResource var1, String var2, Map<String, Object> var3, Map<String, String> var4);

    protected abstract AbstractRequirement createRequirement(AbstractResource var1, String var2, Map<String, Object> var3, Map<String, String> var4);

    @Override
    public Capability addIdentityCapability(ResourceIdentity identity) {
        IllegalArgumentAssertion.assertNotNull(identity, "identity");
        return this.addIdentityCapability(identity.getSymbolicName(), identity.getVersion());
    }

    @Override
    public Capability addIdentityCapability(String symbolicName, String version) {
        IllegalArgumentAssertion.assertNotNull(symbolicName, "symbolicName");
        return this.addIdentityCapability(symbolicName, version != null ? Version.parseVersion(version) : null, null, null);
    }

    @Override
    public Capability addIdentityCapability(String symbolicName, Version version) {
        IllegalArgumentAssertion.assertNotNull(symbolicName, "symbolicName");
        return this.addIdentityCapability(symbolicName, version, null, null);
    }

    @Override
    public Capability addIdentityCapability(MavenCoordinates mavenid) {
        Capability icap = this.addIdentityCapability(MavenUtils.getSymbolicName(mavenid), MavenUtils.getVersion(mavenid), null, null);
        icap.getAttributes().put("maven.identity", mavenid.toExternalForm());
        return icap;
    }

    @Override
    public Capability addIdentityCapability(String symbolicName, Version version, Map<String, Object> atts, Map<String, String> dirs) {
        IllegalArgumentAssertion.assertNotNull(symbolicName, "symbolicName");
        Capability icap = this.addCapability("gravia.identity", symbolicName);
        if (version != null) {
            icap.getAttributes().put("version", version);
        }
        if (atts != null) {
            icap.getAttributes().putAll(atts);
        }
        if (dirs != null) {
            icap.getDirectives().putAll(dirs);
        }
        return icap;
    }

    @Override
    public Capability addContentCapability(InputStream content) {
        IllegalArgumentAssertion.assertNotNull(content, "content");
        Map<String, Object> atts = Collections.singletonMap("stream", content);
        return this.addCapability("gravia.content", atts, null);
    }

    @Override
    public Capability addContentCapability(InputStream content, Map<String, Object> atts, Map<String, String> dirs) {
        IllegalArgumentAssertion.assertNotNull(content, "content");
        LinkedHashMap<String, Object> exatts = new LinkedHashMap<String, Object>();
        if (atts != null) {
            exatts.putAll(atts);
        }
        exatts.put("stream", content);
        return this.addCapability("gravia.content", exatts, dirs);
    }

    @Override
    public Capability addContentCapability(URL contentURL) {
        IllegalArgumentAssertion.assertNotNull(contentURL, "contentURL");
        Map<String, Object> atts = Collections.singletonMap("url", contentURL);
        return this.addCapability("gravia.content", atts, null);
    }

    @Override
    public Capability addContentCapability(URL contentURL, Map<String, Object> atts, Map<String, String> dirs) {
        IllegalArgumentAssertion.assertNotNull(contentURL, "contentURL");
        LinkedHashMap<String, Object> exatts = new LinkedHashMap<String, Object>();
        if (atts != null) {
            exatts.putAll(atts);
        }
        exatts.put("url", contentURL);
        return this.addCapability("gravia.content", exatts, dirs);
    }

    @Override
    public Capability addCapability(String namespace, String nsvalue) {
        IllegalArgumentAssertion.assertNotNull(namespace, "namespace");
        IllegalArgumentAssertion.assertNotNull(nsvalue, "nsvalue");
        return this.addCapability(namespace, Collections.singletonMap(namespace, nsvalue), null);
    }

    @Override
    public Capability addCapability(String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        IllegalArgumentAssertion.assertNotNull(namespace, "namespace");
        AbstractResource resource = this.getResourceInternal();
        AbstractCapability cap = this.createCapability(resource, namespace, this.mutableAttributes(atts), this.mutableDirectives(dirs));
        resource.addCapability(cap);
        return cap;
    }

    @Override
    public Requirement addIdentityRequirement(String symbolicName) {
        IllegalArgumentAssertion.assertNotNull(symbolicName, "symbolicName");
        return this.addIdentityRequirement(symbolicName, null, null, null);
    }

    @Override
    public Requirement addIdentityRequirement(String symbolicName, String range) {
        IllegalArgumentAssertion.assertNotNull(symbolicName, "symbolicName");
        return this.addIdentityRequirement(symbolicName, range != null ? new VersionRange(range) : null, null, null);
    }

    @Override
    public Requirement addIdentityRequirement(String symbolicName, VersionRange range) {
        IllegalArgumentAssertion.assertNotNull(symbolicName, "symbolicName");
        return this.addIdentityRequirement(symbolicName, range, null, null);
    }

    @Override
    public Requirement addIdentityRequirement(String symbolicName, VersionRange range, Map<String, Object> atts, Map<String, String> dirs) {
        IllegalArgumentAssertion.assertNotNull(symbolicName, "symbolicName");
        Requirement ireq = this.addRequirement("gravia.identity", symbolicName);
        if (range != null) {
            ireq.getAttributes().put("version", range);
        }
        if (atts != null) {
            ireq.getAttributes().putAll(atts);
        }
        if (dirs != null) {
            ireq.getDirectives().putAll(dirs);
        }
        return ireq;
    }

    @Override
    public Requirement addRequirement(String namespace, String nsvalue) {
        IllegalArgumentAssertion.assertNotNull(namespace, "namespace");
        IllegalArgumentAssertion.assertNotNull(nsvalue, "nsvalue");
        return this.addRequirement(namespace, Collections.singletonMap(namespace, nsvalue), null);
    }

    @Override
    public Requirement addRequirement(String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        IllegalArgumentAssertion.assertNotNull(namespace, "namespace");
        AbstractResource resource = this.getResourceInternal();
        AbstractRequirement req = this.createRequirement(resource, namespace, this.mutableAttributes(atts), this.mutableDirectives(dirs));
        resource.addRequirement(req);
        return req;
    }

    @Override
    public boolean isValid() {
        AbstractResource resource = this.getResourceInternal();
        return resource.isValid();
    }

    @Override
    public Resource getCurrentResource() {
        AbstractResource resource = this.getResourceInternal();
        resource.assertMutable();
        return resource;
    }

    @Override
    public Resource getResource() {
        AbstractResource resource = this.getResourceInternal();
        resource.validate();
        resource.setMutable(false);
        return resource;
    }

    protected String parseParameterizedValue(String line, Map<String, Object> atts, Map<String, String> dirs) {
        IllegalArgumentAssertion.assertNotNull(line, "line");
        String mainvalue = null;
        for (String part : ElementParser.parseDelimitedString(line, ';', true)) {
            Object value;
            int index;
            if (part.indexOf(":=") > 0) {
                index = part.indexOf(":=");
                String key = part.substring(0, index);
                value = this.unquote(part.substring(index + 2));
                dirs.put(key.trim(), (String)value);
                continue;
            }
            if (part.indexOf(61) > 0) {
                index = part.indexOf(61);
                String keystr = part.substring(0, index);
                value = this.getAttributeValue(keystr, part.substring(index + 1));
                atts.put(this.getAttributeKey(keystr), value);
                continue;
            }
            if (mainvalue == null) {
                mainvalue = part;
                continue;
            }
            throw new IllegalArgumentException("Cannot parse: " + line);
        }
        return mainvalue;
    }

    private String getAttributeKey(String keystr) {
        String[] parts = keystr.split(":");
        return parts[0].trim();
    }

    private Object getAttributeValue(String key, String valstr) {
        String[] parts = key.split(":");
        if (parts.length == 1) {
            return this.unquote(valstr);
        }
        String typespec = parts[1].trim();
        if (typespec.startsWith("List")) {
            parts = typespec.split("[<>]");
            typespec = "List<" + (parts.length > 1 ? parts[1].trim() : "String") + ">";
        }
        AttributeValueHandler.AttributeValue attval = AttributeValueHandler.readAttributeValue(typespec, this.unquote(valstr));
        return attval.getValue();
    }

    private String unquote(String value) {
        if ((value = value.trim()).startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    private Map<String, Object> mutableAttributes(Map<String, Object> atts) {
        return new LinkedHashMap<String, Object>(atts != null ? atts : new LinkedHashMap());
    }

    private Map<String, String> mutableDirectives(Map<String, String> dirs) {
        return new LinkedHashMap<String, String>(dirs != null ? dirs : new LinkedHashMap());
    }

    private AbstractResource getResourceInternal() {
        if (this.resource == null) {
            this.resource = this.createResource();
        }
        return this.resource;
    }
}

