/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.provision.spi;

import org.jboss.gravia.provision.ProvisionException;
import org.jboss.gravia.provision.ResourceHandle;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.provision.spi.DefaultInstallerContext;
import org.jboss.gravia.provision.spi.RuntimeEnvironment;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.jboss.gravia.utils.ResourceUtils;

public abstract class AbstractResourceInstaller
implements ResourceInstaller {
    public abstract RuntimeEnvironment getEnvironment();

    @Override
    public ResourceHandle installResource(ResourceInstaller.Context context, Resource res) throws ProvisionException {
        return this.installResourceInternal(context, ResourceUtils.getRequiredRuntimeName((Resource)res), res, this.isShared(res));
    }

    @Override
    public ResourceHandle installSharedResource(ResourceInstaller.Context context, Resource res) throws ProvisionException {
        return this.installResourceInternal(context, ResourceUtils.getRequiredRuntimeName((Resource)res), res, true);
    }

    private synchronized ResourceHandle installResourceInternal(ResourceInstaller.Context context, String runtimeName, Resource resource, boolean shared) throws ProvisionException {
        IllegalArgumentAssertion.assertNotNull((Object)runtimeName, (String)"runtimeName");
        IllegalArgumentAssertion.assertNotNull((Object)resource, (String)"resource");
        if (context == null) {
            context = new DefaultInstallerContext(resource);
        }
        try {
            return this.installResourceProtected(context, runtimeName, resource, shared);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (ProvisionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ProvisionException("Cannot provision resource: " + resource, ex);
        }
    }

    protected abstract ResourceHandle installResourceProtected(ResourceInstaller.Context var1, String var2, Resource var3, boolean var4) throws Exception;

    private boolean isShared(Resource resource) {
        Object attval = resource.getIdentityCapability().getAttribute("shared");
        return Boolean.parseBoolean((String)attval);
    }
}

