/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.provision.internal;

import java.io.InputStream;
import java.util.Map;
import org.jboss.gravia.provision.DefaultResourceHandle;
import org.jboss.gravia.provision.ProvisionException;
import org.jboss.gravia.provision.ResourceHandle;
import org.jboss.gravia.provision.spi.AbstractResourceInstaller;
import org.jboss.gravia.provision.spi.ProvisionLogger;
import org.jboss.gravia.provision.spi.RuntimeEnvironment;
import org.jboss.gravia.resolver.Environment;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceContent;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ModuleException;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleWiring;

class BundleContextResourceInstaller
extends AbstractResourceInstaller {
    private final RuntimeEnvironment environment;
    private final BundleContext bundleContext;

    BundleContextResourceInstaller(ModuleContext context, RuntimeEnvironment environment) {
        this.bundleContext = ((Bundle)context.getModule().adapt(Bundle.class)).getBundleContext();
        this.environment = environment;
    }

    @Override
    public RuntimeEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public ResourceHandle installUnsharedResource(Resource resource, Map<Requirement, Resource> mapping) throws ProvisionException {
        ProvisionLogger.LOGGER.info("Installing unshared resource: {}", (Object)resource);
        return this.installBundleResource(resource);
    }

    @Override
    public ResourceHandle installSharedResource(Resource resource, Map<Requirement, Resource> mapping) throws ProvisionException {
        ProvisionLogger.LOGGER.info("Installing shared resource: {}", (Object)resource);
        return this.installBundleResource(resource);
    }

    private ResourceHandle installBundleResource(Resource resource) throws ProvisionException {
        Resource envres;
        Bundle bundle;
        ResourceIdentity identity = resource.getIdentity();
        InputStream content = ((ResourceContent)resource.adapt(ResourceContent.class)).getContent();
        try {
            bundle = this.bundleContext.installBundle(identity.toString(), content);
        }
        catch (BundleException ex) {
            throw new ProvisionException(ex);
        }
        try {
            bundle.start();
        }
        catch (BundleException ex) {
            // empty catch block
        }
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        Module module = runtime.getModule(identity);
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (module == null && wiring != null) {
            try {
                ClassLoader classLoader = wiring.getClassLoader();
                module = runtime.installModule(classLoader, resource, null);
            }
            catch (ModuleException ex) {
                throw new ProvisionException(ex);
            }
        }
        if ((envres = this.environment.getResource(identity)) == null && module != null) {
            RuntimeEnvironment runtimeEnv = RuntimeEnvironment.assertRuntimeEnvironment((Environment)this.environment);
            runtimeEnv.addRuntimeResource(resource);
        }
        return new BundleResourceHandle(resource, module, bundle);
    }

    static class BundleResourceHandle
    extends DefaultResourceHandle {
        private final Bundle bundle;

        BundleResourceHandle(Resource resource, Module module, Bundle bundle) {
            super(resource, module);
            this.bundle = bundle;
        }

        Bundle getBundle() {
            return this.bundle;
        }

        @Override
        public void uninstall() {
            try {
                this.bundle.uninstall();
            }
            catch (BundleException ex) {
                ProvisionLogger.LOGGER.warn("Cannot uninstall bundle: " + this.bundle, (Throwable)ex);
            }
        }
    }
}

