/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.repository.spi;

import java.io.OutputStream;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.gravia.repository.Namespace100;
import org.jboss.gravia.repository.RepositoryStorageException;
import org.jboss.gravia.repository.RepositoryWriter;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.spi.AttributeValueHandler;

public abstract class AbstractRepositoryXMLWriter
implements RepositoryWriter {
    private final XMLStreamWriter writer;

    public AbstractRepositoryXMLWriter(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("Null outputStream");
        }
        this.writer = this.createXMLStreamWriter(outputStream);
    }

    protected abstract XMLStreamWriter createXMLStreamWriter(OutputStream var1);

    @Override
    public void writeRepositoryElement(Map<String, String> attributes) {
        try {
            this.writer.writeStartDocument();
            this.writer.setDefaultNamespace("http://www.osgi.org/xmlns/repository/v1.0.0");
            this.writer.writeStartElement(Namespace100.Element.REPOSITORY.getLocalName());
            this.writer.writeDefaultNamespace("http://www.osgi.org/xmlns/repository/v1.0.0");
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                this.writer.writeAttribute(entry.getKey(), entry.getValue());
            }
        }
        catch (XMLStreamException ex) {
            throw new RepositoryStorageException("Cannot write repository element", ex);
        }
    }

    @Override
    public void writeResource(Resource resource) {
        try {
            this.writer.writeStartElement(Namespace100.Element.RESOURCE.getLocalName());
            for (Capability cap : resource.getCapabilities(null)) {
                this.writer.writeStartElement(Namespace100.Element.CAPABILITY.getLocalName());
                this.writer.writeAttribute(Namespace100.Attribute.NAMESPACE.getLocalName(), cap.getNamespace());
                this.writeAttributes(cap.getAttributes());
                this.writeDirectives(cap.getDirectives());
                this.writer.writeEndElement();
            }
            for (Requirement req : resource.getRequirements(null)) {
                this.writer.writeStartElement(Namespace100.Element.REQUIREMENT.getLocalName());
                this.writer.writeAttribute(Namespace100.Attribute.NAMESPACE.getLocalName(), req.getNamespace());
                this.writeAttributes(req.getAttributes());
                this.writeDirectives(req.getDirectives());
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException("Cannot initialize repository writer", ex);
        }
    }

    @Override
    public void close() {
        try {
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
            this.writer.close();
        }
        catch (XMLStreamException ex) {
            throw new RepositoryStorageException("Cannot write repository element", ex);
        }
    }

    private void writeAttributes(Map<String, Object> attributes) throws XMLStreamException {
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            AttributeValueHandler.AttributeValue attval = AttributeValueHandler.AttributeValue.create((Object)entry.getValue());
            this.writer.writeStartElement(Namespace100.Element.ATTRIBUTE.getLocalName());
            this.writer.writeAttribute(Namespace100.Attribute.NAME.getLocalName(), entry.getKey());
            if (attval.isListType()) {
                this.writer.writeAttribute(Namespace100.Attribute.VALUE.getLocalName(), attval.getValueString());
                this.writer.writeAttribute(Namespace100.Attribute.TYPE.getLocalName(), "List<" + attval.getType() + ">");
            } else {
                this.writer.writeAttribute(Namespace100.Attribute.VALUE.getLocalName(), attval.getValueString());
                if (attval.getType() != AttributeValueHandler.Type.String) {
                    this.writer.writeAttribute(Namespace100.Attribute.TYPE.getLocalName(), attval.getType().toString());
                }
            }
            this.writer.writeEndElement();
        }
    }

    private void writeDirectives(Map<String, String> directives) throws XMLStreamException {
        for (Map.Entry<String, String> entry : directives.entrySet()) {
            this.writer.writeStartElement(Namespace100.Element.DIRECTIVE.getLocalName());
            this.writer.writeAttribute(Namespace100.Attribute.NAME.getLocalName(), entry.getKey());
            this.writer.writeAttribute(Namespace100.Attribute.VALUE.getLocalName(), entry.getValue());
            this.writer.writeEndElement();
        }
    }
}

