/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.process.spi;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.gravia.process.api.ManagedProcessOptions;
import org.jboss.gravia.resource.MavenCoordinates;
import org.jboss.gravia.utils.IllegalStateAssertion;

public abstract class AbstractManagedProcessOptions
implements ManagedProcessOptions {
    private List<MavenCoordinates> mavenCoordinates = new ArrayList<MavenCoordinates>();
    private boolean outputToConsole;
    private String javaVmArguments;
    private File targetDirectory;

    @Override
    public List<MavenCoordinates> getMavenCoordinates() {
        return Collections.unmodifiableList(this.mavenCoordinates);
    }

    @Override
    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    @Override
    public String getJavaVmArguments() {
        return this.javaVmArguments;
    }

    @Override
    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    protected void addMavenCoordinates(MavenCoordinates coordinates) {
        this.mavenCoordinates.add(coordinates);
    }

    protected void setTargetDirectory(File target) {
        this.targetDirectory = target;
    }

    protected void setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
    }

    protected void setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
    }

    protected void validate() {
        IllegalStateAssertion.assertNotNull((Object)this.targetDirectory, (String)"targetDirectory");
    }
}

