/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.repository.spi;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.gravia.repository.MavenDelegateRepository;
import org.jboss.gravia.repository.spi.AbstractRepository;
import org.jboss.gravia.repository.spi.RepositoryLogger;
import org.jboss.gravia.repository.spi.SecurityActions;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.MavenCoordinates;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.runtime.spi.DefaultPropertiesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;

public abstract class AbstractMavenDelegateRepository
extends AbstractRepository
implements MavenDelegateRepository {
    private final List<URL> baserepos;

    public AbstractMavenDelegateRepository() {
        this((PropertiesProvider)new DefaultPropertiesProvider());
    }

    public AbstractMavenDelegateRepository(PropertiesProvider propertyProvider) {
        super(propertyProvider);
        Configuration configuration = this.getConfiguration(propertyProvider);
        this.baserepos = Collections.unmodifiableList(configuration.getBaseURLs());
    }

    protected Configuration getConfiguration(final PropertiesProvider propertyProvider) {
        return new Configuration(){

            @Override
            public List<URL> getBaseURLs() {
                ArrayList<URL> result = new ArrayList<URL>();
                String property = (String)propertyProvider.getProperty("org.jboss.gravia.repository.maven.base.urls");
                if (property == null) {
                    property = "";
                    String userhome = SecurityActions.getSystemProperty("user.home", "");
                    File localrepo = new File(userhome + File.separator + ".m2" + File.separator + "repository");
                    if (localrepo.isDirectory()) {
                        property = property + localrepo.toURI().toString() + ",";
                    }
                    property = property + "http://repository.jboss.org/nexus/content/groups/public,";
                    property = property + "http://repo1.maven.org/maven2";
                }
                for (String urlspec : property.split(",")) {
                    result.add(AbstractMavenDelegateRepository.getBaseURL(urlspec));
                }
                return Collections.unmodifiableList(result);
            }
        };
    }

    @Override
    public Collection<Capability> findProviders(Requirement req) {
        MavenCoordinates mavenid = (MavenCoordinates)req.getAttribute("maven.identity");
        if (mavenid == null) {
            return Collections.emptyList();
        }
        Resource resource = this.findMavenResource(mavenid);
        if (resource == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(resource.getIdentityCapability());
    }

    @Override
    public Resource findMavenResource(MavenCoordinates mavenid) {
        RepositoryLogger.LOGGER.info("Find maven providers for: {}", (Object)mavenid);
        URL contentURL = null;
        for (URL baseURL : this.baserepos) {
            URL url = mavenid.getArtifactURL(baseURL);
            try {
                url.openStream().close();
                contentURL = url;
                break;
            }
            catch (IOException e) {
                RepositoryLogger.LOGGER.debug("Cannot access input stream for: {}", (Object)url);
            }
        }
        Resource result = null;
        if (contentURL != null) {
            DefaultResourceBuilder builder = new DefaultResourceBuilder();
            builder.addIdentityCapability(mavenid);
            Capability ccap = builder.addCapability("gravia.content", null, null);
            ccap.getAttributes().put("url", contentURL);
            result = builder.getResource();
            RepositoryLogger.LOGGER.debug("Found maven resource: {}", (Object)result);
        }
        return result;
    }

    private static URL getBaseURL(String urlspec) {
        try {
            return new URL(urlspec);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid repository base: " + urlspec);
        }
    }

    public static interface Configuration {
        public static final String JBOSS_NEXUS_BASE = "http://repository.jboss.org/nexus/content/groups/public";
        public static final String MAVEN_CENTRAL_BASE = "http://repo1.maven.org/maven2";

        public List<URL> getBaseURLs();
    }
}

