/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.provision.spi;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.gravia.provision.ProvisionException;
import org.jboss.gravia.provision.ProvisionResult;
import org.jboss.gravia.provision.Provisioner;
import org.jboss.gravia.provision.ResourceHandle;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.provision.spi.DefaultInstallerContext;
import org.jboss.gravia.provision.spi.ProvisionLogger;
import org.jboss.gravia.repository.MavenIdentityRequirementBuilder;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.resolver.DefaultPreferencePolicy;
import org.jboss.gravia.resolver.DefaultResolveContext;
import org.jboss.gravia.resolver.Environment;
import org.jboss.gravia.resolver.PreferencePolicy;
import org.jboss.gravia.resolver.ResolutionException;
import org.jboss.gravia.resolver.ResolveContext;
import org.jboss.gravia.resolver.Resolver;
import org.jboss.gravia.resolver.spi.AbstractEnvironment;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.MavenCoordinates;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceBuilder;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.runtime.DefaultWire;
import org.jboss.gravia.runtime.DefaultWiring;
import org.jboss.gravia.runtime.Wire;
import org.jboss.gravia.runtime.Wiring;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.jboss.gravia.utils.IllegalStateAssertion;
import org.jboss.gravia.utils.ResourceUtils;

public abstract class AbstractProvisioner
implements Provisioner {
    private final Resolver resolver;
    private final Repository repository;
    private final Environment environment;
    private final ResourceInstaller installer;
    private final PreferencePolicy preferencePolicy;

    public AbstractProvisioner(Environment environment, Resolver resolver, Repository repository, ResourceInstaller installer) {
        this(environment, resolver, repository, installer, (PreferencePolicy)new DefaultPreferencePolicy(null));
    }

    public AbstractProvisioner(Environment environment, Resolver resolver, Repository repository, ResourceInstaller installer, PreferencePolicy policy) {
        IllegalArgumentAssertion.assertNotNull((Object)environment, (String)"environment");
        IllegalArgumentAssertion.assertNotNull((Object)resolver, (String)"resolver");
        IllegalArgumentAssertion.assertNotNull((Object)repository, (String)"repository");
        IllegalArgumentAssertion.assertNotNull((Object)installer, (String)"installer");
        IllegalArgumentAssertion.assertNotNull((Object)policy, (String)"policy");
        this.environment = environment;
        this.resolver = resolver;
        this.repository = repository;
        this.installer = installer;
        this.preferencePolicy = policy;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public final Resolver getResolver() {
        return this.resolver;
    }

    @Override
    public final Repository getRepository() {
        return this.repository;
    }

    @Override
    public ResourceInstaller getResourceInstaller() {
        return this.installer;
    }

    @Override
    public ProvisionResult findResources(Set<Requirement> reqs) {
        return this.findResources(this.getEnvironment().cloneEnvironment(), reqs);
    }

    @Override
    public ProvisionResult findResources(Environment env, Set<Requirement> reqs) {
        IllegalArgumentAssertion.assertNotNull((Object)env, (String)"env");
        IllegalArgumentAssertion.assertNotNull(reqs, (String)"reqs");
        ProvisionLogger.LOGGER.debug("START findResources: {}", reqs);
        ArrayList<Resource> unresolved = new ArrayList<Resource>();
        for (Requirement req : reqs) {
            Resource res = req.getResource();
            if (env.getResource(res.getIdentity()) != null) continue;
            env.addResource(res);
            unresolved.add(res);
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        HashSet<Requirement> unstatisfied = new HashSet<Requirement>(reqs);
        HashMap<Requirement, Resource> mapping = new HashMap<Requirement, Resource>();
        this.findResources(env, unresolved, mapping, unstatisfied, resources);
        Iterator itres = resources.iterator();
        while (itres.hasNext()) {
            Resource res = (Resource)itres.next();
            if (!ResourceUtils.isAbstract((Resource)res)) continue;
            itres.remove();
        }
        ArrayList<Resource> sorted = new ArrayList<Resource>();
        for (Resource res : resources) {
            this.sortResultResources(res, mapping, resources, sorted);
        }
        DefaultProvisionResult result = new DefaultProvisionResult(sorted, mapping, env.getWirings(), unstatisfied);
        ProvisionLogger.LOGGER.debug("END findResources");
        ProvisionLogger.LOGGER.debug("  resources: {}", result.getResources());
        ProvisionLogger.LOGGER.debug("  unsatisfied: {}", result.getUnsatisfiedRequirements());
        LinkedHashSet<Resource> mandatory = new LinkedHashSet<Resource>();
        mandatory.addAll(result.getResources());
        try {
            DefaultResolveContext context = new DefaultResolveContext(env, mandatory, null);
            this.resolver.resolveAndApply((ResolveContext)context).entrySet();
        }
        catch (ResolutionException ex) {
            ProvisionLogger.LOGGER.warn("Cannot resolve provisioner result", (Throwable)ex);
        }
        return result;
    }

    @Override
    public Set<ResourceHandle> provisionResources(Set<Requirement> reqs) throws ProvisionException {
        Environment env = this.getEnvironment();
        Environment envclone = env.cloneEnvironment();
        ProvisionResult result = this.findResources(envclone, reqs);
        Set<Requirement> unsatisfied = result.getUnsatisfiedRequirements();
        if (!unsatisfied.isEmpty()) {
            throw new ProvisionException("Cannot resolve unsatisfied requirements: " + unsatisfied);
        }
        List<Resource> resources = result.getResources();
        Map<Requirement, Resource> mapping = result.getMapping();
        DefaultInstallerContext context = new DefaultInstallerContext(resources, mapping);
        Set<ResourceHandle> handles = this.installResources(context);
        this.updateResourceWiring(env, result);
        return handles;
    }

    @Override
    public void updateResourceWiring(Environment environment, ProvisionResult result) {
        Map<Resource, Wiring> auxwirings = result.getWirings();
        for (Map.Entry<Resource, Wiring> entry : auxwirings.entrySet()) {
            Requirement envreq;
            Requirement auxreq;
            Capability envcap;
            Capability auxcap;
            Resource auxres = entry.getKey();
            Resource envres = environment.getResource(auxres.getIdentity());
            DefaultWiring envwiring = new DefaultWiring(envres, null, null);
            Wiring auxwiring = entry.getValue();
            for (Wire auxwire : auxwiring.getProvidedResourceWires(null)) {
                auxcap = auxwire.getCapability();
                envcap = this.findTargetCapability(auxcap);
                auxreq = auxwire.getRequirement();
                envreq = this.findTargetRequirement(auxreq);
                envwiring.addProvidedWire((Wire)new DefaultWire(envreq, envcap));
            }
            for (Wire auxwire : auxwiring.getRequiredResourceWires(null)) {
                auxcap = auxwire.getCapability();
                envcap = this.findTargetCapability(auxcap);
                auxreq = auxwire.getRequirement();
                envreq = this.findTargetRequirement(auxreq);
                envwiring.addRequiredWire((Wire)new DefaultWire(envreq, envcap));
            }
            AbstractEnvironment absenv = AbstractEnvironment.assertAbstractEnvironment((Environment)environment);
            absenv.putWiring(envres, (Wiring)envwiring);
        }
    }

    private Set<ResourceHandle> installResources(ResourceInstaller.Context context) throws ProvisionException {
        IllegalArgumentAssertion.assertNotNull((Object)context, (String)"context");
        HashSet<ResourceHandle> handles = new HashSet<ResourceHandle>();
        for (Resource res : context.getResources()) {
            handles.add(this.installer.installResource(context, res));
        }
        return Collections.unmodifiableSet(handles);
    }

    @Override
    public ResourceBuilder getContentResourceBuilder(ResourceIdentity identity, InputStream inputStream) {
        IllegalArgumentAssertion.assertNotNull((Object)identity, (String)"identity");
        IllegalArgumentAssertion.assertNotNull((Object)inputStream, (String)"inputStream");
        DefaultResourceBuilder builder = new DefaultResourceBuilder();
        builder.addIdentityCapability(identity);
        builder.addContentCapability(inputStream);
        return builder;
    }

    @Override
    public ResourceBuilder getMavenResourceBuilder(ResourceIdentity identity, MavenCoordinates mavenid) {
        IllegalArgumentAssertion.assertNotNull((Object)mavenid, (String)"mavenid");
        Requirement ireq = new MavenIdentityRequirementBuilder(mavenid).getRequirement();
        Collection providers = this.getRepository().findProviders(ireq);
        IllegalStateAssertion.assertFalse((Boolean)providers.isEmpty(), (String)("Cannot find providers for requirement: " + ireq));
        Resource mvnres = ((Capability)providers.iterator().next()).getResource();
        DefaultResourceBuilder builder = new DefaultResourceBuilder();
        Capability icap = identity != null ? builder.addIdentityCapability(identity) : builder.addIdentityCapability(mavenid);
        icap.getAttributes().put("maven.identity", mavenid);
        for (Capability cap : mvnres.getCapabilities(null)) {
            if ("gravia.identity".equals(cap.getNamespace())) continue;
            builder.addCapability(cap.getNamespace(), cap.getAttributes(), cap.getDirectives());
        }
        for (Requirement req : mvnres.getRequirements(null)) {
            builder.addRequirement(req.getNamespace(), req.getAttributes(), req.getDirectives());
        }
        return builder;
    }

    @Override
    public ResourceHandle installResource(Resource resource) throws ProvisionException {
        return this.installResourceInternal(resource);
    }

    @Override
    public ResourceHandle installSharedResource(Resource resource) throws ProvisionException {
        if (!ResourceUtils.isShared((Resource)resource)) {
            ResourceBuilder builder = new DefaultResourceBuilder().fromResource(resource);
            Capability icap = builder.getMutableResource().getIdentityCapability();
            icap.getAttributes().put("shared", Boolean.TRUE);
            resource = builder.getResource();
        }
        return this.installResourceInternal(resource);
    }

    private synchronized ResourceHandle installResourceInternal(Resource resource) throws ProvisionException {
        IllegalArgumentAssertion.assertNotNull((Object)resource, (String)"resource");
        DefaultInstallerContext context = new DefaultInstallerContext(resource);
        return this.installer.installResource(context, resource);
    }

    private Capability findTargetCapability(Capability auxcap) {
        Resource envres;
        Resource auxres = auxcap.getResource();
        if (auxres == (envres = this.environment.getResource(auxres.getIdentity()))) {
            return auxcap;
        }
        for (Capability cap : envres.getCapabilities(null)) {
            boolean nsmatch = cap.getNamespace().equals(auxcap.getNamespace());
            boolean attsmatch = cap.getAttributes().equals(auxcap.getAttributes());
            boolean dirsmatch = cap.getDirectives().equals(auxcap.getDirectives());
            if (!nsmatch || !attsmatch || !dirsmatch) continue;
            return cap;
        }
        throw new IllegalStateException("Cannot find target capability for: " + auxcap);
    }

    private Requirement findTargetRequirement(Requirement auxreq) {
        Resource envres;
        Resource auxres = auxreq.getResource();
        if (auxres == (envres = this.environment.getResource(auxres.getIdentity()))) {
            return auxreq;
        }
        for (Requirement req : envres.getRequirements(null)) {
            boolean nsmatch = req.getNamespace().equals(auxreq.getNamespace());
            boolean attsmatch = req.getAttributes().equals(auxreq.getAttributes());
            boolean dirsmatch = req.getDirectives().equals(auxreq.getDirectives());
            if (!nsmatch || !attsmatch || !dirsmatch) continue;
            return req;
        }
        throw new IllegalStateException("Cannot find target requirement for: " + auxreq);
    }

    private void sortResultResources(Resource res, Map<Requirement, Resource> mapping, List<Resource> resources, List<Resource> result) {
        if (!result.contains(res)) {
            for (Requirement req : res.getRequirements(null)) {
                Resource target = mapping.get(req);
                if (target == null || !resources.contains(target)) continue;
                this.sortResultResources(target, mapping, resources, result);
            }
            result.add(res);
        }
    }

    private void findResources(Environment env, List<Resource> unresolved, Map<Requirement, Resource> mapping, Set<Requirement> unstatisfied, List<Resource> resources) {
        this.resolveInEnvironment(env, unresolved, mapping, unstatisfied, resources);
        if (unstatisfied.isEmpty()) {
            return;
        }
        boolean envModified = false;
        HashSet<Resource> installable = new HashSet<Resource>();
        ProvisionLogger.LOGGER.debug("Finding unsatisfied reqs");
        for (Requirement req : unstatisfied) {
            Capability cap;
            if (!env.findProviders(req).isEmpty() || (cap = this.findProviderInRepository(req)) == null) continue;
            installable.add(cap.getResource());
        }
        for (Resource res : installable) {
            if (resources.contains(res)) continue;
            List reqs = res.getRequirements(null);
            ProvisionLogger.LOGGER.debug("Adding %d unsatisfied reqs", (Object)reqs.size());
            unstatisfied.addAll(reqs);
            env.addResource(res);
            resources.add(res);
            envModified = true;
        }
        if (envModified) {
            this.findResources(env, unresolved, mapping, unstatisfied, resources);
        }
    }

    private Capability findProviderInRepository(Requirement req) {
        ProvisionLogger.LOGGER.debug("Find in repository: {}", (Object)req);
        ArrayList providers = this.repository.findProviders(req);
        if (providers.size() > 1) {
            providers = new ArrayList(providers);
            Iterator itcap = providers.iterator();
            while (itcap.hasNext()) {
                Capability cap = (Capability)itcap.next();
                if (!ResourceUtils.isAbstract((Resource)cap.getResource())) continue;
                itcap.remove();
            }
        }
        Capability cap = null;
        if (providers.size() == 1) {
            cap = (Capability)providers.iterator().next();
            ProvisionLogger.LOGGER.debug(" Found one: {}", (Object)cap);
        } else if (providers.size() > 1) {
            ArrayList sorted = new ArrayList(providers);
            this.preferencePolicy.sort(sorted);
            ProvisionLogger.LOGGER.debug(" Found multiple: {}", sorted);
            cap = (Capability)sorted.get(0);
        } else {
            ProvisionLogger.LOGGER.debug(" Not found: {}", (Object)req);
        }
        return cap;
    }

    private void resolveInEnvironment(Environment env, List<Resource> unresolved, Map<Requirement, Resource> mapping, Set<Requirement> unstatisfied, List<Resource> resources) {
        LinkedHashSet<Resource> mandatory = new LinkedHashSet<Resource>();
        mandatory.addAll(unresolved);
        mandatory.addAll(resources);
        try {
            DefaultResolveContext context = new DefaultResolveContext(env, mandatory, null);
            Set wiremap = this.resolver.resolve((ResolveContext)context).entrySet();
            for (Map.Entry entry : wiremap) {
                for (Wire wire : (List)entry.getValue()) {
                    Requirement req = wire.getRequirement();
                    Resource provider = wire.getProvider();
                    mapping.put(req, provider);
                }
            }
            unstatisfied.clear();
        }
        catch (ResolutionException ex) {
            for (Requirement req : ex.getUnresolvedRequirements()) {
                ProvisionLogger.LOGGER.debug(" unresolved: {}", (Object)req);
            }
        }
    }

    static class DefaultProvisionResult
    implements ProvisionResult {
        private final Map<Resource, Wiring> wirings;
        private final Map<Requirement, Resource> mapping;
        private final Set<Requirement> unsatisfied;
        private final List<Resource> resources;

        DefaultProvisionResult(List<Resource> resources, Map<Requirement, Resource> mapping, Map<Resource, Wiring> wirings, Set<Requirement> unstatisfied) {
            this.resources = resources;
            this.mapping = mapping;
            this.wirings = wirings;
            this.unsatisfied = unstatisfied;
        }

        @Override
        public List<Resource> getResources() {
            return Collections.unmodifiableList(this.resources);
        }

        @Override
        public Map<Requirement, Resource> getMapping() {
            return Collections.unmodifiableMap(this.mapping);
        }

        @Override
        public Map<Resource, Wiring> getWirings() {
            return Collections.unmodifiableMap(this.wirings);
        }

        @Override
        public Set<Requirement> getUnsatisfiedRequirements() {
            return Collections.unmodifiableSet(this.unsatisfied);
        }
    }
}

