/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.MavenCoordinates;

public final class CompositeDataResourceBuilder
extends DefaultResourceBuilder {
    public CompositeDataResourceBuilder(CompositeData resData) {
        CompositeData[] reqsData;
        CompositeData[] capsData;
        for (CompositeData capData : capsData = (CompositeData[])resData.get("capabilities")) {
            String namespace = (String)capData.get("namespace");
            CompositeData[] attsData = (CompositeData[])capData.get("attributes");
            Map<String, Object> atts = this.getAttributes(attsData);
            CompositeData[] dirsData = (CompositeData[])capData.get("directives");
            Map<String, String> dirs = this.getDirectives(dirsData);
            this.addCapability(namespace, atts, dirs);
        }
        for (CompositeData reqData : reqsData = (CompositeData[])resData.get("requirements")) {
            String namespace = (String)reqData.get("namespace");
            CompositeData[] attsData = (CompositeData[])reqData.get("attributes");
            Map<String, Object> atts = this.getAttributes(attsData);
            CompositeData[] dirsData = (CompositeData[])reqData.get("directives");
            Map<String, String> dirs = this.getDirectives(dirsData);
            this.addRequirement(namespace, atts, dirs);
        }
    }

    private Map<String, Object> getAttributes(CompositeData[] attsData) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (CompositeData attData : attsData) {
            String key = (String)attData.get("key");
            Object value = attData.get("value");
            if ("maven.identity".equals(key)) {
                value = MavenCoordinates.parse((String)value);
            }
            result.put(key, value);
        }
        return result;
    }

    private Map<String, String> getDirectives(CompositeData[] dirsData) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (CompositeData dirData : dirsData) {
            String key = (String)dirData.get("key");
            String value = (String)dirData.get("value");
            result.put(key, value);
        }
        return result;
    }
}

