/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.repository;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.gravia.repository.MavenCoordinates;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.Version;

public class MavenResourceBuilder
extends DefaultResourceBuilder {
    private static final Pattern FUZZY_VERSION = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?", 32);

    public Capability addIdentityCapability(MavenCoordinates mavenid) {
        Capability icap = this.addIdentityCapability(MavenResourceBuilder.getSymbolicName(mavenid), MavenResourceBuilder.getVersion(mavenid), null, null);
        icap.getAttributes().put("maven.identity", mavenid.toExternalForm());
        return icap;
    }

    public static String getSymbolicName(MavenCoordinates mavenid) {
        return mavenid.getGroupId() + "." + mavenid.getArtifactId();
    }

    public static Version getVersion(MavenCoordinates mavenid) {
        return Version.parseVersion((String)MavenResourceBuilder.cleanupVersion(mavenid.getVersion()));
    }

    private static String cleanupVersion(String version) {
        StringBuffer result = new StringBuffer();
        Matcher m = FUZZY_VERSION.matcher(version);
        if (m.matches()) {
            String major = m.group(1);
            String minor = m.group(3);
            String micro = m.group(5);
            String qualifier = m.group(7);
            if (major != null) {
                result.append(major);
                if (minor != null) {
                    result.append(".");
                    result.append(minor);
                    if (micro != null) {
                        result.append(".");
                        result.append(micro);
                        if (qualifier != null) {
                            result.append(".");
                            MavenResourceBuilder.cleanupModifier(result, qualifier);
                        }
                    } else if (qualifier != null) {
                        result.append(".0.");
                        MavenResourceBuilder.cleanupModifier(result, qualifier);
                    } else {
                        result.append(".0");
                    }
                } else if (qualifier != null) {
                    result.append(".0.0.");
                    MavenResourceBuilder.cleanupModifier(result, qualifier);
                } else {
                    result.append(".0.0");
                }
            }
        } else {
            result.append("0.0.0.");
            MavenResourceBuilder.cleanupModifier(result, version);
        }
        return result.toString();
    }

    private static void cleanupModifier(StringBuffer result, String modifier) {
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') {
                result.append(c);
                continue;
            }
            result.append('_');
        }
    }
}

