/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.repository.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.gravia.repository.MavenCoordinates;
import org.jboss.gravia.repository.MavenDelegateRepository;
import org.jboss.gravia.repository.Namespace100;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.repository.RepositoryAggregator;
import org.jboss.gravia.repository.RepositoryReader;
import org.jboss.gravia.repository.RepositoryStorageException;
import org.jboss.gravia.repository.RepositoryWriter;
import org.jboss.gravia.repository.spi.MemoryRepositoryStorage;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.ContentCapability;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceBuilder;
import org.jboss.gravia.resource.ResourceContent;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.runtime.spi.PropertiesProvider;

public abstract class AbstractRepositoryStorage
extends MemoryRepositoryStorage {
    private final AtomicLong increment = new AtomicLong();

    public AbstractRepositoryStorage(PropertiesProvider propertyProvider, Repository repository) {
        super(propertyProvider, repository);
    }

    public void initRepositoryStorage() throws RepositoryStorageException {
        RepositoryReader reader = this.getPersistentRepositoryReader();
        if (reader != null) {
            String incatt = reader.getRepositoryAttributes().get(Namespace100.Attribute.INCREMENT.getLocalName());
            this.increment.set(incatt != null ? new Long(incatt).longValue() : this.increment.get());
            Resource res = reader.nextResource();
            while (res != null) {
                this.addResourceInternal(res, false);
                res = reader.nextResource();
            }
            reader.close();
        }
    }

    protected abstract ResourceBuilder createResourceBuilder();

    protected abstract RepositoryReader getPersistentRepositoryReader() throws RepositoryStorageException;

    protected abstract RepositoryWriter getPersistentRepositoryWriter() throws RepositoryStorageException;

    protected abstract void addResourceContent(InputStream var1, Map<String, Object> var2) throws RepositoryStorageException;

    protected abstract URL getBaseURL();

    @Override
    public Resource addResource(Resource res) throws RepositoryStorageException {
        return this.addResourceInternal(res, true);
    }

    private synchronized Resource addResourceInternal(Resource resource, boolean writeXML) throws RepositoryStorageException {
        if (resource == null) {
            throw new IllegalArgumentException("Null resource");
        }
        Capability icap = resource.getIdentityCapability();
        List ccaps = resource.getCapabilities("gravia.content");
        String mvnatt = (String)icap.getAttribute("maven.identity");
        if (ccaps.isEmpty() && mvnatt != null) {
            MavenCoordinates mvnid = MavenCoordinates.parse(mvnatt);
            Resource mvnres = this.getMavenResource(mvnid);
            ccaps = mvnres.getCapabilities("gravia.content");
        }
        if (ccaps.size() > 0) {
            return this.addContentResource(resource, ccaps, writeXML);
        }
        return this.addAbstractResource(resource, writeXML);
    }

    private Resource getMavenResource(MavenCoordinates mavenid) {
        MavenDelegateRepository mvnrepo = null;
        Repository repository = this.getRepository();
        Repository delegate = repository.getFallbackRepository();
        if (delegate instanceof MavenDelegateRepository) {
            mvnrepo = (MavenDelegateRepository)delegate;
        } else if (delegate instanceof RepositoryAggregator) {
            RepositoryAggregator aggregator = (RepositoryAggregator)delegate;
            for (Repository repo : aggregator.getDelegates()) {
                if (!(repo instanceof MavenDelegateRepository)) continue;
                mvnrepo = (MavenDelegateRepository)repo;
                break;
            }
        }
        return mvnrepo != null ? mvnrepo.findMavenResource(mavenid) : null;
    }

    private Resource addContentResource(Resource res, List<Capability> ccaps, boolean writeXML) throws RepositoryStorageException {
        URL urlatt = (URL)ccaps.get(0).getAttribute("url");
        if (urlatt == null || !urlatt.toExternalForm().startsWith(this.getBaseURL().toExternalForm())) {
            ResourceBuilder builder = this.createResourceBuilder();
            for (Capability cap : res.getCapabilities(null)) {
                if ("gravia.content".equals(cap.getNamespace())) continue;
                builder.addCapability(cap.getNamespace(), cap.getAttributes(), cap.getDirectives());
            }
            for (Capability cap : ccaps) {
                ContentCapability ccap = (ContentCapability)cap.adapt(ContentCapability.class);
                HashMap<String, Object> contentAtts = new HashMap<String, Object>();
                String mimeType = (String)ccap.getAttribute("mime");
                if (mimeType != null) {
                    contentAtts.put("mime", mimeType);
                }
                InputStream input = this.getResourceContent(ccap);
                try {
                    this.addResourceContent(input, contentAtts);
                    builder.addCapability("gravia.content", contentAtts, cap.getDirectives());
                }
                catch (RepositoryStorageException ex) {
                    throw new RepositoryStorageException("Cannot add resource to storeage: " + mimeType, ex);
                }
            }
            for (Requirement req : res.getRequirements(null)) {
                String namespace = req.getNamespace();
                builder.addRequirement(namespace, req.getAttributes(), req.getDirectives());
            }
            res = builder.getResource();
        }
        Resource result = super.addResource(res);
        if (writeXML) {
            this.writeRepositoryXML();
        }
        return result;
    }

    private Resource addAbstractResource(Resource res, boolean writeXML) throws RepositoryStorageException {
        Resource result = super.addResource(res);
        if (writeXML) {
            this.writeRepositoryXML();
        }
        return result;
    }

    @Override
    public Resource removeResource(ResourceIdentity resid) {
        return this.removeResourceInternal(resid, true);
    }

    private synchronized Resource removeResourceInternal(ResourceIdentity resid, boolean writeXML) {
        Capability ccap;
        URL fileURL;
        File contentFile;
        Resource res = this.getResource(resid);
        List ccaps = res.getCapabilities("gravia.content");
        if (!ccaps.isEmpty() && (contentFile = new File((fileURL = (URL)(ccap = (Capability)ccaps.iterator().next()).getAttribute("url")).toExternalForm().substring("file:".length()))).exists()) {
            this.deleteRecursive(contentFile.getParentFile());
        }
        super.removeResource(res.getIdentity());
        if (writeXML) {
            this.writeRepositoryXML();
        }
        return res;
    }

    private InputStream getResourceContent(ContentCapability ccap) {
        InputStream input;
        Resource resource = ccap.getResource();
        Capability defaultContent = (Capability)resource.getCapabilities("gravia.content").get(0);
        if (defaultContent == ccap) {
            input = ((ResourceContent)resource.adapt(ResourceContent.class)).getContent();
        } else {
            URL contentURL = ccap.getContentURL();
            try {
                input = contentURL.openStream();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot access content URL: " + contentURL, ex);
            }
        }
        return input;
    }

    private void writeRepositoryXML() {
        RepositoryWriter writer;
        try {
            writer = this.getPersistentRepositoryWriter();
        }
        catch (RepositoryStorageException ex) {
            throw new IllegalStateException("Cannot initialize repository writer", ex);
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(Namespace100.Attribute.NAME.getLocalName(), this.getRepository().getName());
        attributes.put(Namespace100.Attribute.INCREMENT.getLocalName(), this.increment.toString());
        writer.writeRepositoryElement(attributes);
        RepositoryReader reader = this.getRepositoryReader();
        Resource resource = reader.nextResource();
        while (resource != null) {
            writer.writeResource(resource);
            resource = reader.nextResource();
        }
        writer.close();
    }

    private boolean deleteRecursive(File file) {
        boolean result = true;
        if (file.isDirectory()) {
            for (File aux : file.listFiles()) {
                result &= this.deleteRecursive(aux);
            }
        }
        return result &= file.delete();
    }
}

