/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.spi;

import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.gravia.resource.Attachable;
import org.jboss.gravia.resource.AttachmentKey;
import org.jboss.gravia.resource.DictionaryResourceBuilder;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.Version;
import org.jboss.gravia.resource.spi.AttachableSupport;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.spi.AbstractRuntime;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.runtime.spi.RuntimeLogger;
import org.jboss.gravia.utils.CaseInsensitiveDictionary;
import org.jboss.gravia.utils.NotNullException;
import org.jboss.gravia.utils.UnmodifiableDictionary;
import org.osgi.framework.Bundle;

public abstract class AbstractModule
implements Module,
Attachable {
    public static AttachmentKey<ModuleEntriesProvider> MODULE_ENTRIES_PROVIDER_KEY = AttachmentKey.create(ModuleEntriesProvider.class);
    private final AbstractRuntime runtime;
    private final ClassLoader classLoader;
    private final Resource resource;
    private final Dictionary<String, String> headers;
    private final Attachable attachments = new AttachableSupport();
    private final ConcurrentHashMap<ServiceReference<?>, AtomicInteger> usedServices = new ConcurrentHashMap();

    protected AbstractModule(AbstractRuntime runtime, ClassLoader classLoader, Resource resource, Dictionary<String, String> headers) {
        NotNullException.assertValue((Object)runtime, (String)"runtime");
        NotNullException.assertValue((Object)classLoader, (String)"classLoader");
        this.runtime = runtime;
        this.classLoader = classLoader;
        if (resource == null && headers == null) {
            throw new IllegalArgumentException("Cannot create module identity");
        }
        if (resource == null) {
            DictionaryResourceBuilder builder = new DictionaryResourceBuilder().load(headers);
            resource = builder.getResource();
        }
        this.resource = resource;
        ResourceIdentity resourceIdentity = resource.getIdentity();
        Hashtable<String, String> clonedHeaders = new Hashtable<String, String>();
        if (headers != null) {
            Enumeration<String> keys = headers.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = headers.get(key);
                clonedHeaders.put(key, value);
            }
        }
        if (clonedHeaders.get("Gravia-Identity") == null) {
            String identityHeader = this.getIdentityHeader(resourceIdentity);
            clonedHeaders.put("Gravia-Identity", identityHeader);
        }
        this.headers = new UnmodifiableDictionary((Dictionary)new CaseInsensitiveDictionary(clonedHeaders));
        ResourceIdentity headersIdentity = new DictionaryResourceBuilder().load(clonedHeaders).getResource().getIdentity();
        if (!resourceIdentity.equals((Object)headersIdentity)) {
            throw new IllegalArgumentException("Resource and header identity does not match: " + resourceIdentity);
        }
    }

    public static AbstractModule assertAbstractModule(Module module) {
        if (!(module instanceof AbstractModule)) {
            throw new IllegalArgumentException("Not an AbstractModule: " + module);
        }
        return (AbstractModule)module;
    }

    private String getIdentityHeader(ResourceIdentity identity) {
        String symbolicName = identity.getSymbolicName();
        Version version = identity.getVersion();
        return symbolicName + ";version=" + version;
    }

    protected abstract void setState(Module.State var1);

    protected AbstractRuntime getRuntime() {
        return this.runtime;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public ResourceIdentity getIdentity() {
        return this.resource.getIdentity();
    }

    @Override
    public <A> A adapt(Class<A> type) {
        Object result = null;
        if (type.isAssignableFrom(Bundle.class)) {
            result = this.getBundleAdaptor(this);
        } else if (type.isAssignableFrom(Runtime.class)) {
            result = this.runtime;
        } else if (type.isAssignableFrom(AbstractRuntime.class)) {
            result = this.runtime;
        } else if (type.isAssignableFrom(ClassLoader.class)) {
            result = this.classLoader;
        } else if (type.isAssignableFrom(Resource.class)) {
            result = this.resource;
        } else if (type.isAssignableFrom(Module.class)) {
            result = this;
        } else if (type.isAssignableFrom(ModuleContext.class)) {
            result = this.getModuleContext();
        } else if (type.isAssignableFrom(ModuleEntriesProvider.class)) {
            result = this.getAttachment(MODULE_ENTRIES_PROVIDER_KEY);
        }
        return (A)result;
    }

    protected abstract Bundle getBundleAdaptor(Module var1);

    public <T> T putAttachment(AttachmentKey<T> key, T value) {
        return (T)this.attachments.putAttachment(key, value);
    }

    public <T> T getAttachment(AttachmentKey<T> key) {
        return (T)this.attachments.getAttachment(key);
    }

    public <T> boolean hasAttachment(AttachmentKey<T> key) {
        return this.attachments.hasAttachment(key);
    }

    public <T> T removeAttachment(AttachmentKey<T> key) {
        return (T)this.attachments.removeAttachment(key);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        this.assertNotUninstalled();
        return this.classLoader.loadClass(className);
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public URL getEntry(String path) {
        ModuleEntriesProvider entriesProvider = this.adapt(ModuleEntriesProvider.class);
        return entriesProvider != null ? entriesProvider.getEntry(path) : null;
    }

    @Override
    public List<String> getEntryPaths(String path) {
        ModuleEntriesProvider entriesProvider = this.adapt(ModuleEntriesProvider.class);
        return entriesProvider != null ? entriesProvider.getEntryPaths(path) : Collections.emptyList();
    }

    @Override
    public List<URL> findEntries(String path, String filePattern, boolean recurse) {
        ModuleEntriesProvider entriesProvider = this.adapt(ModuleEntriesProvider.class);
        return entriesProvider != null ? entriesProvider.findEntries(path, filePattern, recurse) : Collections.emptyList();
    }

    public Set<ServiceReference<?>> getServicesInUseInternal() {
        return Collections.unmodifiableSet(this.usedServices.keySet());
    }

    public void addServiceInUse(ServiceReference<?> serviceState) {
        RuntimeLogger.LOGGER.trace("Add service in use {} to: {}", serviceState, (Object)this);
        this.usedServices.putIfAbsent(serviceState, new AtomicInteger());
        AtomicInteger count = this.usedServices.get(serviceState);
        count.incrementAndGet();
    }

    public int removeServiceInUse(ServiceReference<?> serviceState) {
        RuntimeLogger.LOGGER.trace("Remove service in use {} from: {}", serviceState, (Object)this);
        AtomicInteger count = this.usedServices.get(serviceState);
        if (count == null) {
            return -1;
        }
        int countVal = count.decrementAndGet();
        if (countVal == 0) {
            this.usedServices.remove(serviceState);
        }
        return countVal;
    }

    protected void assertNotUninstalled() {
        if (this.getState() == Module.State.UNINSTALLED) {
            throw new IllegalStateException("Module already uninstalled: " + this);
        }
    }

    public String toString() {
        return "Module[" + this.getIdentity() + "]";
    }
}

