/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.container.tomcat.support;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.utils.NotNullException;

public class ServletContextEntriesProvider
implements ModuleEntriesProvider {
    private final ServletContext servletContext;

    public ServletContextEntriesProvider(ServletContext servletContext) {
        NotNullException.assertValue((Object)servletContext, (String)"servletContext");
        this.servletContext = servletContext;
    }

    public URL getEntry(String path) {
        try {
            return this.servletContext.getResource(path);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public List<String> getEntryPaths(String path) {
        throw new UnsupportedOperationException();
    }

    public List<URL> findEntries(String path, String filePattern, boolean recurse) {
        NotNullException.assertValue((Object)path, (String)"path");
        if (recurse) {
            throw new UnsupportedOperationException("Cannot handle recursive resource discovery");
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (filePattern == null) {
            filePattern = "*";
        }
        ArrayList<URL> result = new ArrayList<URL>();
        Set paths = this.servletContext.getResourcePaths(path);
        if (paths != null) {
            Pattern pattern = this.convertToPattern(filePattern);
            for (String childPath : paths) {
                int index = childPath.lastIndexOf(47);
                String filename = index >= 0 ? childPath.substring(index + 1) : childPath;
                if (!pattern.matcher(filename).matches()) continue;
                try {
                    URL resurl = this.servletContext.getResource(path + "/" + filename);
                    result.add(resurl);
                }
                catch (MalformedURLException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    private Pattern convertToPattern(String filePattern) {
        filePattern = filePattern.replace("*", ".*");
        return Pattern.compile("^" + filePattern + "$");
    }
}

