/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.embedded.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.ServiceLoader;
import java.util.Vector;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleException;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.embedded.internal.EmbeddedModule;
import org.jboss.gravia.runtime.embedded.internal.RuntimeServicesManager;
import org.jboss.gravia.runtime.embedded.internal.RuntimeStorageHandler;
import org.jboss.gravia.runtime.spi.AbstractModule;
import org.jboss.gravia.runtime.spi.AbstractRuntime;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.RuntimeEventsManager;
import org.jboss.gravia.runtime.spi.RuntimePlugin;

public final class EmbeddedRuntime
extends AbstractRuntime {
    private final RuntimeServicesManager serviceManager = new RuntimeServicesManager(this.adapt(RuntimeEventsManager.class));
    private final RuntimeStorageHandler storageHandler;

    public EmbeddedRuntime(PropertiesProvider propertiesProvider) {
        super(propertiesProvider);
        this.storageHandler = new RuntimeStorageHandler(propertiesProvider, true);
    }

    public void init() {
        ArrayList<Module> pluginModules = new ArrayList<Module>();
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ServiceLoader<RuntimePlugin> services = ServiceLoader.load(RuntimePlugin.class, EmbeddedRuntime.class.getClassLoader());
        for (RuntimePlugin plugin : services) {
            try {
                Module module = plugin.installPluginModule((Runtime)this, classLoader);
                pluginModules.add(module);
            }
            catch (ModuleException ex) {
                LOGGER.errorf((Throwable)ex, "Cannot load plugin: %s", (Object)plugin.getClass().getName());
            }
        }
        for (Module module : pluginModules) {
            try {
                module.start();
            }
            catch (ModuleException ex) {
                LOGGER.errorf((Throwable)ex, "Cannot start plugin: %s", (Object)module);
            }
        }
    }

    public AbstractModule createModule(ClassLoader classLoader, Resource resource, Dictionary<String, String> headers) {
        return new EmbeddedModule(this, classLoader, resource, headers);
    }

    public ModuleEntriesProvider getModuleEntriesProvider(Module module) {
        return new CLassLoaderEntriesProvider((ClassLoader)module.adapt(ClassLoader.class));
    }

    public <A> A adapt(Class<A> type) {
        Object result = super.adapt(type);
        if (result == null) {
            if (type.isAssignableFrom(RuntimeServicesManager.class)) {
                result = this.serviceManager;
            } else if (type.isAssignableFrom(RuntimeStorageHandler.class)) {
                result = this.storageHandler;
            }
        }
        return (A)result;
    }

    protected void uninstallModule(Module module) {
        super.uninstallModule(module);
    }

    private class CLassLoaderEntriesProvider
    implements ModuleEntriesProvider {
        private final ClassLoader classLoader;

        CLassLoaderEntriesProvider(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public URL getEntry(String path) {
            return this.classLoader.getResource(path);
        }

        public Enumeration<String> getEntryPaths(String path) {
            throw new UnsupportedOperationException("Bundle.getEntryPaths(String)");
        }

        public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
            if (filePattern.contains("*") || recurse) {
                throw new UnsupportedOperationException("Bundle.getEntryPaths(String,String,boolean)");
            }
            URL result = this.classLoader.getResource(path + "/" + filePattern);
            if (result == null) {
                return null;
            }
            Vector<URL> vector = new Vector<URL>();
            vector.add(result);
            return vector.elements();
        }
    }
}

