/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.embedded.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ServiceException;
import org.jboss.gravia.runtime.ServiceFactory;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.runtime.embedded.internal.RuntimeServicesManager;
import org.jboss.gravia.runtime.embedded.internal.ServiceReferenceComparator;
import org.jboss.gravia.runtime.embedded.internal.ServiceReferenceWrapper;
import org.jboss.gravia.runtime.embedded.internal.ServiceRegistrationWrapper;
import org.jboss.gravia.runtime.spi.AbstractModule;
import org.jboss.gravia.runtime.util.NotNullException;
import org.jboss.gravia.runtime.util.UnmodifiableDictionary;
import org.jboss.logging.Logger;
import org.jboss.osgi.metadata.CaseInsensitiveDictionary;

final class ServiceState<S>
implements ServiceRegistration<S>,
ServiceReference<S> {
    private static Logger LOGGER = Logger.getLogger(ServiceState.class);
    private final RuntimeServicesManager serviceManager;
    private final Module ownerModule;
    private final String[] classNames;
    private final ValueProvider<S> valueProvider;
    private final ServiceReference<S> reference;
    private final Set<AbstractModule> usingModules = new HashSet<AbstractModule>();
    private final Map<ResourceIdentity, ServiceFactoryHolder<S>> factoryValues;
    private final ServiceRegistration<S> registration;
    private CaseInsensitiveDictionary prevProperties;
    private CaseInsensitiveDictionary currProperties;
    private Object propsLock = new Object();
    private String cachedToString;

    ServiceState(RuntimeServicesManager serviceManager, Module owner, long serviceId, String[] classNames, ValueProvider<S> valueProvider, Dictionary properties) {
        assert (serviceManager != null) : "Null serviceManager";
        assert (owner != null) : "Null owner";
        assert (classNames != null && classNames.length > 0) : "Null clazzes";
        assert (valueProvider != null) : "Null valueProvider";
        this.serviceManager = serviceManager;
        this.ownerModule = owner;
        this.valueProvider = valueProvider;
        this.classNames = classNames;
        if (!valueProvider.isFactoryValue() && !this.checkValidClassNames(owner, classNames, valueProvider.getValue())) {
            throw new IllegalArgumentException("Invalid objectClass: " + Arrays.toString(classNames));
        }
        if (properties == null) {
            properties = new Hashtable<String, Long>();
        }
        ((Dictionary)properties).put("service.id", serviceId);
        ((Dictionary)properties).put("objectClass", (Long)classNames);
        this.currProperties = new CaseInsensitiveDictionary(properties);
        this.cachedToString = this.updateCachedToString();
        this.registration = new ServiceRegistrationWrapper<S>(this);
        this.reference = new ServiceReferenceWrapper<S>(this);
        this.factoryValues = valueProvider.isFactoryValue() ? new ConcurrentHashMap() : null;
    }

    static ServiceState assertServiceState(ServiceReference sref) {
        assert (sref != null) : "Null sref";
        if (sref instanceof ServiceReferenceWrapper) {
            sref = ((ServiceReferenceWrapper)((Object)sref)).getServiceState();
        }
        return sref;
    }

    S getScopedValue(Module module) {
        if (!this.valueProvider.isFactoryValue()) {
            return this.valueProvider.getValue();
        }
        S result = null;
        try {
            ServiceFactoryHolder<Object> factoryHolder = this.getFactoryHolder(module);
            if (factoryHolder == null) {
                ServiceFactory factory = (ServiceFactory)this.valueProvider.getValue();
                factoryHolder = new ServiceFactoryHolder(module, factory);
                this.factoryValues.put(module.getIdentity(), factoryHolder);
            }
            if ((result = (S)factoryHolder.getService()) == null) {
                ServiceException sex = new ServiceException("Cannot get factory value", 2);
                LOGGER.error((Object)sex);
            }
        }
        catch (Throwable th) {
            ServiceException sex = new ServiceException("Cannot get factory value", 3, th);
            LOGGER.error((Object)sex);
        }
        return result;
    }

    void ungetScopedValue(Module module) {
        ServiceFactoryHolder<S> factoryHolder;
        if (this.valueProvider.isFactoryValue() && (factoryHolder = this.getFactoryHolder(module)) != null) {
            try {
                factoryHolder.ungetService();
            }
            catch (RuntimeException rte) {
                ServiceException sex = new ServiceException("Cannot unget factory value", 3, (Throwable)rte);
                LOGGER.error((Object)sex);
            }
        }
    }

    private ServiceFactoryHolder<S> getFactoryHolder(Module module) {
        return this.factoryValues != null ? this.factoryValues.get(module.getIdentity()) : null;
    }

    ServiceRegistration<S> getRegistration() {
        return this.registration;
    }

    List<String> getClassNames() {
        return Arrays.asList(this.classNames);
    }

    public ServiceReference<S> getReference() {
        this.assertNotUnregistered();
        return this.reference;
    }

    public void unregister() {
        this.assertNotUnregistered();
        this.unregisterInternal();
    }

    private void unregisterInternal() {
        this.serviceManager.unregisterService(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String key) {
        Object object = this.propsLock;
        synchronized (object) {
            return key != null ? this.currProperties.get((Object)key) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPropertyKeys() {
        Object object = this.propsLock;
        synchronized (object) {
            ArrayList result = new ArrayList();
            Enumeration keys = this.currProperties.keys();
            while (keys.hasMoreElements()) {
                result.add(keys.nextElement());
            }
            return result.toArray(new String[result.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary properties) {
        this.assertNotUnregistered();
        Object object = this.propsLock;
        synchronized (object) {
            this.prevProperties = this.currProperties;
            if (properties == null) {
                properties = new Hashtable<String, Object>();
            }
            ((Dictionary)properties).put("service.id", this.currProperties.get((Object)"service.id"));
            ((Dictionary)properties).put("objectClass", this.currProperties.get((Object)"objectClass"));
            this.currProperties = new CaseInsensitiveDictionary(properties);
        }
        this.serviceManager.fireServiceEvent(this.ownerModule, 2, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dictionary<String, ?> getPreviousProperties() {
        Object object = this.propsLock;
        synchronized (object) {
            return new UnmodifiableDictionary((Dictionary)this.prevProperties);
        }
    }

    Module getServiceOwner() {
        return this.ownerModule;
    }

    public Module getModule() {
        return this.isUnregistered() ? null : this.ownerModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUsingModule(AbstractModule module) {
        Set<AbstractModule> set = this.usingModules;
        synchronized (set) {
            this.usingModules.add(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUsingModule(AbstractModule module) {
        Set<AbstractModule> set = this.usingModules;
        synchronized (set) {
            this.usingModules.remove(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<AbstractModule> getUsingModulesInternal() {
        Set<AbstractModule> set = this.usingModules;
        synchronized (set) {
            return Collections.unmodifiableSet(new HashSet<AbstractModule>(this.usingModules));
        }
    }

    public boolean isAssignableTo(Module module, String className) {
        Class<?> serviceClass;
        Class<?> targetClass;
        NotNullException.assertValue((Object)module, (String)"module");
        NotNullException.assertValue((Object)className, (String)"className");
        if (module == this.ownerModule || className.startsWith("java.")) {
            return true;
        }
        if (module.getState() == Module.State.UNINSTALLED) {
            return false;
        }
        ClassLoader moduleClassLoader = (ClassLoader)module.adapt(ClassLoader.class);
        if (moduleClassLoader == null) {
            LOGGER.infof("No ClassLoader for: %s", (Object)module);
            return false;
        }
        try {
            targetClass = moduleClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.tracef("Requesting module [%s] cannot load class: %s", (Object)module, (Object)className);
            return true;
        }
        ClassLoader ownerClassLoader = (ClassLoader)this.ownerModule.adapt(ClassLoader.class);
        if (ownerClassLoader == null) {
            LOGGER.tracef("Registrant module [%s] has no class loader for: %s", (Object)this.ownerModule, (Object)className);
            return true;
        }
        try {
            serviceClass = ownerClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            LOGGER.tracef("Registrant module [%s] cannot load class: %s", (Object)this.ownerModule, (Object)className);
            return true;
        }
        if (targetClass != serviceClass) {
            LOGGER.tracef("Not assignable: %s", (Object)className);
            return false;
        }
        return true;
    }

    public int compareTo(Object sref) {
        if (!(sref instanceof ServiceReference)) {
            throw new IllegalArgumentException("Invalid ServiceReference: " + sref);
        }
        Comparator<ServiceReference<?>> comparator = ServiceReferenceComparator.getInstance();
        return comparator.compare(this, (ServiceReference)sref);
    }

    boolean isUnregistered() {
        return this.registration == null;
    }

    private void assertNotUnregistered() {
        if (this.isUnregistered()) {
            throw new IllegalStateException("Service unregistered: " + this);
        }
    }

    private boolean checkValidClassNames(Module module, String[] classNames, Object value) {
        assert (module != null) : "Null module";
        assert (classNames != null && classNames.length > 0) : "Null service classes";
        assert (value != null) : "Null value";
        if (value instanceof ServiceFactory) {
            return true;
        }
        boolean result = true;
        for (String className : classNames) {
            if (className == null) {
                result = false;
                break;
            }
            try {
                Class<?> valueClass = value.getClass();
                Class<?> clazz = Class.forName(className, false, valueClass.getClassLoader());
                if (clazz.isAssignableFrom(valueClass)) continue;
                LOGGER.errorf("Service interface [%s] loaded from [%s] is not assignable from [%s] loaded from [%s]", new Object[]{className, clazz.getClassLoader(), valueClass.getName(), valueClass.getClassLoader()});
                result = false;
            }
            catch (ClassNotFoundException ex) {
                LOGGER.errorf("Cannot load [%s] from: %s", (Object)className, (Object)module);
                result = false;
            }
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String updateCachedToString() {
        Object object = this.propsLock;
        synchronized (object) {
            Hashtable<String, List<String>> props = new Hashtable<String, List<String>>((Map<String, List<String>>)this.currProperties);
            String[] classes = (String[])this.currProperties.get((Object)"objectClass");
            props.put("objectClass", Arrays.asList(classes));
            return "ServiceState" + props;
        }
    }

    public String toString() {
        return this.cachedToString.toString();
    }

    class ServiceFactoryHolder<T> {
        ServiceFactory factory;
        Module module;
        AtomicInteger useCount;
        T value;

        ServiceFactoryHolder(Module module, ServiceFactory factory) {
            this.module = module;
            this.factory = factory;
            this.useCount = new AtomicInteger();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T getService() {
            if (this.useCount.get() == 0) {
                Module module = this.module;
                synchronized (module) {
                    Object retValue = this.factory.getService(this.module, ServiceState.this.getRegistration());
                    if (retValue == null) {
                        return null;
                    }
                    if (!ServiceState.this.checkValidClassNames(ServiceState.this.ownerModule, (String[])ServiceState.this.getProperty("objectClass"), retValue)) {
                        return null;
                    }
                    this.value = retValue;
                }
            }
            this.useCount.incrementAndGet();
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ungetService() {
            if (this.useCount.get() == 0) {
                return;
            }
            if (this.useCount.decrementAndGet() == 0) {
                Module module = this.module;
                synchronized (module) {
                    this.factory.ungetService(this.module, ServiceState.this.getRegistration(), this.value);
                    this.value = null;
                }
            }
        }
    }

    static interface ValueProvider<S> {
        public boolean isFactoryValue();

        public S getValue();
    }
}

