/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.tomcat;

import java.io.IOException;
import java.net.URL;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.jboss.gravia.resource.Attachable;
import org.jboss.gravia.resource.ManifestResourceBuilder;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.spi.AttachableSupport;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleException;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.RuntimeFactory;
import org.jboss.gravia.runtime.tomcat.TomcatRuntime;
import org.jboss.gravia.runtime.tomcat.TomcatRuntimeFactory;
import org.jboss.gravia.runtime.util.DefaultPropertiesProvider;
import org.jboss.gravia.runtime.util.ManifestHeadersProvider;

@WebListener
public class ApplicationActivator
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent event) {
        Module module;
        ServletContext servletContext = event.getServletContext();
        Runtime runtime = RuntimeLocator.getRuntime();
        if (runtime == null) {
            TomcatRuntimeFactory runtimeFactory = new TomcatRuntimeFactory();
            DefaultPropertiesProvider propsProvider = new DefaultPropertiesProvider();
            runtime = RuntimeLocator.createRuntime((RuntimeFactory)runtimeFactory, (PropertiesProvider)propsProvider);
            runtime.init();
        }
        if ((module = this.installWebappModule(runtime, servletContext)) != null) {
            try {
                module.start();
            }
            catch (ModuleException ex) {
                throw new IllegalStateException(ex);
            }
            servletContext.setAttribute(Module.class.getName(), (Object)module);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        Module module = (Module)servletContext.getAttribute(Module.class.getName());
        if (module != null && module.getState() != Module.State.UNINSTALLED) {
            module.uninstall();
        }
    }

    private Module installWebappModule(Runtime runtime, ServletContext servletContext) {
        Module module;
        ClassLoader classLoader = ApplicationActivator.class.getClassLoader();
        Manifest manifest = this.getWebappManifest(servletContext);
        if (manifest == null) {
            return null;
        }
        ManifestResourceBuilder resbuilder = new ManifestResourceBuilder().load(manifest);
        if (!resbuilder.isValid()) {
            return null;
        }
        AttachableSupport context = new AttachableSupport();
        context.putAttachment(TomcatRuntime.SERVLET_CONTEXT_KEY, (Object)servletContext);
        try {
            Resource resource = resbuilder.getResource();
            ManifestHeadersProvider headersProvider = new ManifestHeadersProvider(manifest);
            module = runtime.installModule(classLoader, resource, headersProvider.getHeaders(), (Attachable)context);
            servletContext.setAttribute(Module.class.getName(), (Object)module);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (ModuleException ex) {
            throw new IllegalStateException(ex);
        }
        return module;
    }

    private Manifest getWebappManifest(ServletContext servletContext) {
        Manifest manifest = null;
        try {
            URL entry = servletContext.getResource("/META-INF/MANIFEST.MF");
            if (entry != null) {
                manifest = new Manifest(entry.openStream());
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot read manifest", ex);
        }
        return manifest;
    }
}

