/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.tomcat;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.utils.NotNullException;

public class ServletContextEntriesProvider
implements ModuleEntriesProvider {
    private final ServletContext servletContext;

    public ServletContextEntriesProvider(ServletContext servletContext) {
        NotNullException.assertValue((Object)servletContext, (String)"servletContext");
        this.servletContext = servletContext;
    }

    public URL getEntry(String path) {
        try {
            return this.servletContext.getResource(path);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public Enumeration<String> getEntryPaths(String path) {
        throw new UnsupportedOperationException("Bundle.getEntryPaths(String)");
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        URL result;
        if (filePattern.contains("*") || recurse) {
            throw new UnsupportedOperationException("Bundle.getEntryPaths(String,String,boolean)");
        }
        try {
            result = this.servletContext.getResource(path + "/" + filePattern);
        }
        catch (MalformedURLException e) {
            result = null;
        }
        if (result == null) {
            return null;
        }
        Vector<URL> vector = new Vector<URL>();
        vector.add(result);
        return vector.elements();
    }
}

