/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.spi.ElementParser;

public final class DictionaryResourceBuilder
extends DefaultResourceBuilder {
    public DictionaryResourceBuilder load(Dictionary<String, String> headers) {
        Enumeration<String> keys = headers.keys();
        while (keys.hasMoreElements()) {
            String namespace;
            LinkedHashMap<String, String> dirs;
            LinkedHashMap<String, Object> atts;
            String key = keys.nextElement();
            String value = headers.get(key);
            if ("Gravia-Identity".equals(key)) {
                LinkedHashMap<String, Object> atts2 = new LinkedHashMap<String, Object>();
                LinkedHashMap<String, String> dirs2 = new LinkedHashMap<String, String>();
                String symbolicName = this.parseParameterizedValue(value, atts2, dirs2);
                this.addIdentityCapability(symbolicName, null, atts2, dirs2);
                continue;
            }
            if ("Gravia-IdentityRequirement".equals(key)) {
                for (String part : ElementParser.parseDelimitedString(value, ',')) {
                    atts = new LinkedHashMap<String, Object>();
                    dirs = new LinkedHashMap<String, String>();
                    String symbolicName = this.parseParameterizedValue(part, atts, dirs);
                    this.addIdentityRequirement(symbolicName, null, atts, dirs);
                }
                continue;
            }
            if ("Gravia-Capability".equals(key)) {
                for (String part : ElementParser.parseDelimitedString(value, ',')) {
                    atts = new LinkedHashMap();
                    dirs = new LinkedHashMap();
                    namespace = this.parseParameterizedValue(part, atts, dirs);
                    this.addCapability(namespace, atts, dirs);
                }
                continue;
            }
            if (!"Gravia-Requirement".equals(key)) continue;
            for (String part : ElementParser.parseDelimitedString(value, ',')) {
                atts = new LinkedHashMap();
                dirs = new LinkedHashMap();
                namespace = this.parseParameterizedValue(part, atts, dirs);
                this.addRequirement(namespace, atts, dirs);
            }
        }
        return this;
    }
}

