/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource.spi;

import java.util.ArrayList;
import java.util.List;
import org.jboss.gravia.resource.Version;
import org.jboss.gravia.resource.VersionRange;

public final class AttributeValueHandler {
    public static AttributeValue readAttributeValue(String typespec, String valstr) {
        ArrayList<String> value;
        boolean listType = false;
        if (typespec != null && typespec.startsWith("List<") && typespec.endsWith(">")) {
            typespec = typespec.substring(5, typespec.length() - 1);
            listType = true;
        }
        Type type = typespec != null ? Type.valueOf(typespec) : Type.String;
        valstr = valstr.trim();
        switch (type) {
            case String: {
                if (listType) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (String val : AttributeValueHandler.split(valstr)) {
                        list.add(val.trim());
                    }
                    value = list;
                    break;
                }
                value = valstr;
                break;
            }
            case Version: {
                if (listType) {
                    ArrayList<Version> list = new ArrayList<Version>();
                    for (String val : AttributeValueHandler.split(valstr)) {
                        list.add(Version.parseVersion(val.trim()));
                    }
                    value = list;
                    break;
                }
                value = Version.parseVersion(valstr);
                break;
            }
            case VersionRange: {
                if (listType) {
                    ArrayList<VersionRange> list = new ArrayList<VersionRange>();
                    for (String val : AttributeValueHandler.split(valstr)) {
                        list.add(new VersionRange(val.trim()));
                    }
                    value = list;
                    break;
                }
                value = new VersionRange(valstr);
                break;
            }
            case Long: {
                if (listType) {
                    ArrayList<Long> list = new ArrayList<Long>();
                    for (String val : AttributeValueHandler.split(valstr)) {
                        list.add(Long.parseLong(val.trim()));
                    }
                    value = list;
                    break;
                }
                value = Long.parseLong(valstr);
                break;
            }
            case Double: {
                if (listType) {
                    ArrayList<Double> list = new ArrayList<Double>();
                    for (String val : AttributeValueHandler.split(valstr)) {
                        list.add(Double.parseDouble(val.trim()));
                    }
                    value = list;
                    break;
                }
                value = Double.parseDouble(valstr);
                break;
            }
            default: {
                value = valstr;
            }
        }
        return new AttributeValue(type, value);
    }

    private static List<String> split(String valstr) {
        boolean escape = false;
        StringBuffer tok = new StringBuffer();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < valstr.length(); ++i) {
            char ch = valstr.charAt(i);
            if (ch == '\\' && !escape) {
                escape = true;
                continue;
            }
            if (escape && ch != '\\' && ch != ',' && ch != '\"') {
                tok.append('\\');
                escape = false;
            }
            if (ch == ',' && !escape) {
                result.add(tok.toString());
                tok = new StringBuffer();
                escape = false;
                continue;
            }
            tok.append(ch);
            escape = false;
        }
        if (tok.length() > 0) {
            result.add(tok.toString());
        }
        return result;
    }

    public static class AttributeValue {
        private final Type type;
        private final Object value;
        private final boolean listType;

        public static AttributeValue parse(String external) {
            String typespec = external.substring(external.indexOf("type=") + 5, external.indexOf(44));
            String valuestr = external.substring(external.indexOf("value=") + 6, external.length() - 1);
            return AttributeValueHandler.readAttributeValue(typespec, valuestr);
        }

        public static AttributeValue create(Object value) {
            Class<Object> valueType = value.getClass();
            boolean listType = List.class.isAssignableFrom(valueType);
            if (listType) {
                List list = (List)value;
                valueType = !list.isEmpty() ? list.get(0).getClass() : String.class;
            }
            Type type = Type.valueOf(valueType.getSimpleName());
            return new AttributeValue(type, value);
        }

        private AttributeValue(Type type, Object value) {
            assert (type != null) : "Null type";
            assert (value != null) : "Null value";
            this.type = type;
            this.value = value;
            Class<?> valueClass = value.getClass();
            this.listType = List.class.isAssignableFrom(valueClass);
        }

        public Type getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public String getValueString() {
            StringBuffer result = new StringBuffer();
            if (this.listType) {
                for (Object val : (List)this.value) {
                    if (result.length() > 0) {
                        result.append(", ");
                    }
                    result.append(this.escape(val));
                }
            } else {
                result.append(this.value);
            }
            return result.toString();
        }

        private String escape(Object val) {
            String valstr = val.toString();
            if (this.type != Type.String) {
                return valstr;
            }
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < valstr.length(); ++i) {
                char ch = valstr.charAt(i);
                if (ch == '\\' || ch == ',' || ch == '\"') {
                    result.append("\\" + ch);
                    continue;
                }
                result.append(ch);
            }
            return result.toString();
        }

        public boolean isListType() {
            return this.listType;
        }

        public String toExternalForm() {
            String typespec = this.listType ? "List<" + (Object)((Object)this.type) + ">" : "" + (Object)((Object)this.type);
            String valstr = this.value.toString();
            if (this.listType) {
                valstr = valstr.substring(1, valstr.length() - 1);
            }
            return "[type=" + typespec + ", value=" + valstr + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AttributeValue other = (AttributeValue)obj;
            if (this.type != other.type) {
                return false;
            }
            return this.value.equals(other.value);
        }

        public String toString() {
            return this.toExternalForm();
        }
    }

    public static enum Type {
        String,
        Version,
        VersionRange,
        Long,
        Double;

    }
}

