/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.repository.spi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.Requirement;
import org.jboss.logging.Logger;

public abstract class AbstractRepository
implements Repository {
    static final Logger LOGGER = Logger.getLogger((String)Repository.class.getPackage().getName());

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public <T> T adapt(Class<T> type) {
        AbstractRepository result = null;
        if (type.isAssignableFrom(this.getClass())) {
            result = this;
        }
        return (T)result;
    }

    @Override
    public Map<Requirement, Collection<Capability>> findProviders(Collection<Requirement> reqs) {
        if (reqs == null) {
            throw new IllegalArgumentException("Null reqs");
        }
        HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>();
        for (Requirement req : reqs) {
            Collection<Capability> providers = this.findProviders(req);
            result.put(req, providers);
        }
        return result;
    }
}

