/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.process.spi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.jboss.gravia.process.api.ManagedProcess;
import org.jboss.gravia.process.api.ManagedProcessOptions;
import org.jboss.gravia.process.api.PortManager;
import org.jboss.gravia.repository.DefaultMavenDelegateRepository;
import org.jboss.gravia.repository.MavenDelegateRepository;
import org.jboss.gravia.resource.MavenCoordinates;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceContent;
import org.jboss.gravia.runtime.LifecycleException;
import org.jboss.gravia.runtime.ServiceLocator;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.jboss.gravia.utils.IllegalStateAssertion;

public abstract class AbstractManagedProcess<C extends ManagedProcessOptions>
implements ManagedProcess<C> {
    private final MavenDelegateRepository mavenRepository;
    private final C createOptions;
    private File homeDir;
    private ManagedProcess.State state;
    private Process process;

    protected AbstractManagedProcess(C options, PropertiesProvider propsProvider) {
        IllegalArgumentAssertion.assertNotNull(options, (String)"options");
        this.mavenRepository = new DefaultMavenDelegateRepository(propsProvider);
        this.createOptions = options;
    }

    @Override
    public C getCreateOptions() {
        return this.createOptions;
    }

    @Override
    public final synchronized void create() {
        IllegalStateAssertion.assertTrue((Boolean)(this.state == null ? 1 : 0), (String)("Cannot create container in state: " + (Object)((Object)this.state)));
        File targetDir = this.getCreateOptions().getTargetDirectory();
        IllegalStateAssertion.assertTrue((Boolean)(targetDir.isDirectory() || targetDir.mkdirs() ? 1 : 0), (String)("Cannot create target dir: " + targetDir));
        for (MavenCoordinates artefact : this.getCreateOptions().getMavenCoordinates()) {
            Resource resource = this.mavenRepository.findMavenResource(artefact);
            IllegalStateAssertion.assertNotNull((Object)resource, (String)("Cannot find maven resource: " + artefact));
            ResourceContent content = (ResourceContent)resource.adapt(ResourceContent.class);
            IllegalStateAssertion.assertNotNull((Object)content, (String)("Cannot obtain resource content for: " + artefact));
            try {
                boolean needContainerHome;
                TarArchiveInputStream ais;
                InputStream inputStream;
                if ("tar.gz".equals(artefact.getType())) {
                    inputStream = content.getContent();
                    ais = new TarArchiveInputStream((InputStream)new GZIPInputStream(inputStream));
                } else {
                    inputStream = content.getContent();
                    ais = new ArchiveStreamFactory().createArchiveInputStream(artefact.getType(), inputStream);
                }
                ArchiveEntry entry = null;
                boolean bl = needContainerHome = this.homeDir == null;
                while ((entry = ais.getNextEntry()) != null) {
                    File targetFile = needContainerHome ? new File(targetDir, entry.getName()) : new File(this.homeDir, entry.getName());
                    if (entry.isDirectory()) continue;
                    File parentDir = targetFile.getParentFile();
                    IllegalStateAssertion.assertTrue((Boolean)(parentDir.exists() || parentDir.mkdirs() ? 1 : 0), (String)("Cannot create target directory: " + parentDir));
                    FileOutputStream fos = new FileOutputStream(targetFile);
                    IOUtils.copy((InputStream)ais, (OutputStream)fos);
                    fos.close();
                    if (!needContainerHome || this.homeDir != null) continue;
                    File currentDir = parentDir;
                    while (!currentDir.getParentFile().equals(targetDir)) {
                        currentDir = currentDir.getParentFile();
                    }
                    this.homeDir = currentDir;
                }
                ais.close();
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot extract artefact: " + artefact, ex);
            }
        }
        this.state = ManagedProcess.State.CREATED;
        try {
            this.doConfigure();
        }
        catch (Exception ex) {
            throw new LifecycleException("Cannot configure container", (Throwable)ex);
        }
    }

    @Override
    public File getHomeDir() {
        return this.homeDir;
    }

    @Override
    public ManagedProcess.State getState() {
        return this.state;
    }

    @Override
    public final synchronized void start() {
        this.assertNotDestroyed();
        try {
            if (this.state == ManagedProcess.State.CREATED || this.state == ManagedProcess.State.STOPPED) {
                this.doStart();
                this.state = ManagedProcess.State.STARTED;
            }
        }
        catch (Exception ex) {
            throw new LifecycleException("Cannot start container", (Throwable)ex);
        }
    }

    @Override
    public final synchronized void stop() {
        this.assertNotDestroyed();
        try {
            if (this.state == ManagedProcess.State.STARTED) {
                this.doStop();
                this.destroyProcess();
                this.state = ManagedProcess.State.STOPPED;
            }
        }
        catch (Exception ex) {
            throw new LifecycleException("Cannot stop container", (Throwable)ex);
        }
    }

    @Override
    public final synchronized void destroy() {
        this.assertNotDestroyed();
        if (this.state == ManagedProcess.State.STARTED) {
            try {
                this.stop();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            this.doDestroy();
        }
        catch (Exception ex) {
            throw new LifecycleException("Cannot destroy container", (Throwable)ex);
        }
        finally {
            this.state = ManagedProcess.State.DESTROYED;
        }
    }

    private void assertNotDestroyed() {
        IllegalStateAssertion.assertFalse((Boolean)(this.state == ManagedProcess.State.DESTROYED ? 1 : 0), (String)("Cannot start container in state: " + (Object)((Object)this.state)));
    }

    protected void doConfigure() throws Exception {
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    protected void doDestroy() throws Exception {
    }

    protected void startProcess(ProcessBuilder processBuilder) throws IOException {
        this.process = processBuilder.start();
        new Thread(new ConsoleConsumer(this.process, (ManagedProcessOptions)this.getCreateOptions())).start();
    }

    protected void destroyProcess() throws Exception {
        if (this.process != null) {
            this.process.destroy();
            this.process.waitFor();
        }
    }

    protected final int nextAvailablePort(int portValue) {
        return this.nextAvailablePort(portValue, null);
    }

    protected int nextAvailablePort(int portValue, InetAddress bindAddr) {
        PortManager portManager = (PortManager)ServiceLocator.getRequiredService(PortManager.class);
        return portManager.nextAvailablePort(portValue, bindAddr);
    }

    public static class ConsoleConsumer
    implements Runnable {
        private final Process process;
        private final ManagedProcessOptions options;

        public ConsoleConsumer(Process process, ManagedProcessOptions options) {
            this.process = process;
            this.options = options;
        }

        @Override
        public void run() {
            InputStream stream = this.process.getInputStream();
            try {
                int num;
                byte[] buf = new byte[32];
                while ((num = stream.read(buf)) != -1) {
                    if (!this.options.isOutputToConsole()) continue;
                    System.out.write(buf, 0, num);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

