/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.spi;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.utils.NotNullException;

public final class ClassLoaderEntriesProvider
implements ModuleEntriesProvider {
    private final ClassLoader classLoader;

    public ClassLoaderEntriesProvider(Module module) {
        NotNullException.assertValue((Object)module, (String)"module");
        this.classLoader = module.adapt(ClassLoader.class);
    }

    @Override
    public URL getEntry(String path) {
        return this.classLoader.getResource(path);
    }

    @Override
    public List<String> getEntryPaths(String path) {
        throw new UnsupportedOperationException("Bundle.getEntryPaths(String)");
    }

    @Override
    public List<URL> findEntries(String path, String filePattern, boolean recurse) {
        if (filePattern.contains("*") || recurse) {
            throw new UnsupportedOperationException("Bundle.getEntryPaths(String,String,boolean)");
        }
        URL result = this.classLoader.getResource(path + "/" + filePattern);
        if (result == null && !path.startsWith("/")) {
            return this.findEntries("/" + path, filePattern, recurse);
        }
        return result != null ? Collections.singletonList(result) : Collections.emptyList();
    }
}

