/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.embedded.internal;

import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.embedded.AbstractRuntimePlugin;
import org.jboss.gravia.utils.StringPropertyReplacer;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public final class ConfigurationAdminPlugin
extends AbstractRuntimePlugin {
    @Override
    public String getBundleActivator() {
        return "org.apache.felix.cm.impl.ConfigurationManager";
    }

    @Override
    public void start(ModuleContext context) throws Exception {
        super.start(context);
        ServiceReference sref = context.getServiceReference(ConfigurationAdmin.class);
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)context.getService(sref);
        Runtime runtime = (Runtime)context.getModule().adapt(Runtime.class);
        String confspecs = (String)runtime.getProperty("org.jboss.gravia.runtime.configurations");
        if (confspecs != null) {
            for (String spec : confspecs.split(",")) {
                String urlspec = StringPropertyReplacer.replaceProperties((String)spec.trim());
                URL specurl = new URL(urlspec);
                String path = specurl.getPath();
                String pid = path.substring(path.lastIndexOf(47) + 1);
                if (pid.endsWith(".cfg")) {
                    pid = pid.substring(0, pid.length() - 4);
                }
                Properties props = new Properties();
                props.load(specurl.openStream());
                Configuration config = configAdmin.getConfiguration(pid, null);
                config.update(this.propsToMap(props));
            }
        }
    }

    private Dictionary<String, ?> propsToMap(Properties props) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            ((Dictionary)result).put(key, value);
        }
        return result;
    }
}

