/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.embedded.internal;

import java.io.File;
import java.io.IOException;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.RuntimeLogger;

final class RuntimeStorageHandler {
    private final File storageArea;

    RuntimeStorageHandler(PropertiesProvider props, boolean firstInit) {
        String dirName = (String)props.getProperty("org.jboss.gravia.runtime.storage");
        if (dirName == null) {
            try {
                File storageDir = new File("." + File.separator + "gravia-store");
                dirName = storageDir.getCanonicalPath();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot create storage area", ex);
            }
        }
        this.storageArea = new File(dirName).getAbsoluteFile();
        String storageClean = (String)props.getProperty("org.jboss.gravia.runtime.storage.clean");
        if (firstInit && "onFirstInit".equals(storageClean)) {
            RuntimeLogger.LOGGER.debug("Deleting storage: {}", (Object)this.storageArea.getAbsolutePath());
            this.deleteRecursive(this.storageArea);
        }
    }

    File getDataFile(Module module, String filename) {
        File moduleDir = this.getStorageDir(module);
        File dataFile = new File(moduleDir.getAbsolutePath() + File.separator + filename);
        dataFile.getParentFile().mkdirs();
        String filePath = dataFile.getAbsolutePath();
        try {
            filePath = dataFile.getCanonicalPath();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return new File(filePath);
    }

    private File getStorageDir(Module module) {
        String identity = module.getIdentity().toString().replace(':', '-').replace('/', '-');
        File moduleDir = new File(this.storageArea + "/module-" + identity);
        if (!moduleDir.exists()) {
            moduleDir.mkdirs();
        }
        String filePath = moduleDir.getAbsolutePath();
        try {
            filePath = moduleDir.getCanonicalPath();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return new File(filePath);
    }

    private void deleteRecursive(File file) {
        if (file.isDirectory()) {
            for (File aux : file.listFiles()) {
                this.deleteRecursive(aux);
            }
        }
        file.delete();
    }
}

