/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.embedded.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jboss.gravia.resource.Attachable;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ModuleException;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceLocator;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.runtime.embedded.internal.EmbeddedLogServiceFactory;
import org.jboss.gravia.runtime.embedded.internal.EmbeddedModule;
import org.jboss.gravia.runtime.embedded.internal.RuntimeServicesManager;
import org.jboss.gravia.runtime.embedded.internal.RuntimeStorageHandler;
import org.jboss.gravia.runtime.embedded.internal.SystemModule;
import org.jboss.gravia.runtime.spi.AbstractModule;
import org.jboss.gravia.runtime.spi.AbstractRuntime;
import org.jboss.gravia.runtime.spi.ClassLoaderEntriesProvider;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.RuntimeEventsManager;
import org.jboss.gravia.runtime.spi.RuntimeLogger;
import org.jboss.gravia.runtime.spi.RuntimePlugin;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.log.LogService;

public class EmbeddedRuntime
extends AbstractRuntime {
    private final RuntimeServicesManager serviceManager;
    private final RuntimeStorageHandler storageHandler;
    private final List<ServiceRegistration<?>> systemServices = new ArrayList();

    public EmbeddedRuntime(PropertiesProvider propertiesProvider, Attachable context) {
        super(propertiesProvider);
        this.serviceManager = new RuntimeServicesManager(this.adapt(RuntimeEventsManager.class));
        this.storageHandler = new RuntimeStorageHandler(propertiesProvider, true);
        ResourceIdentity sysid = this.getSystemIdentity();
        Resource resource = new DefaultResourceBuilder().addIdentityCapability(sysid).getResource();
        try {
            Hashtable<String, String> headers = new Hashtable<String, String>();
            ((Dictionary)headers).put("Bundle-SymbolicName", sysid.getSymbolicName());
            ((Dictionary)headers).put("Bundle-Version", sysid.getVersion().toString());
            this.installModule(EmbeddedRuntime.class.getClassLoader(), resource, headers, context);
        }
        catch (ModuleException ex) {
            throw new IllegalStateException("Cannot install system module", ex);
        }
    }

    public void init() {
        this.assertNoShutdown();
        ModuleContext syscontext = this.adapt(ModuleContext.class);
        this.systemServices.add(this.registerRuntimeService(syscontext));
        this.systemServices.add(this.registerLogService(syscontext));
        this.systemServices.add(this.registerMBeanServer(syscontext));
        List<Module> pluginModules = this.installPluginModules();
        this.startPluginModules(pluginModules);
        this.loadInitialConfigurations(syscontext);
    }

    private ServiceRegistration<?> registerRuntimeService(ModuleContext syscontext) {
        return syscontext.registerService(Runtime.class, (Object)this, null);
    }

    protected ServiceRegistration<?> registerLogService(ModuleContext syscontext) {
        return syscontext.registerService(LogService.class.getName(), (Object)new EmbeddedLogServiceFactory(), null);
    }

    protected ServiceRegistration<MBeanServer> registerMBeanServer(ModuleContext syscontext) {
        MBeanServer mbeanServer = this.findOrCreateMBeanServer();
        return syscontext.registerService(MBeanServer.class, (Object)mbeanServer, null);
    }

    protected List<Module> installPluginModules() {
        ArrayList<Module> pluginModules = new ArrayList<Module>();
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ServiceLoader<RuntimePlugin> services = ServiceLoader.load(RuntimePlugin.class, EmbeddedRuntime.class.getClassLoader());
        for (RuntimePlugin plugin : services) {
            try {
                Module module = plugin.installPluginModule((Runtime)this, classLoader);
                if (module == null) continue;
                pluginModules.add(module);
            }
            catch (ModuleException ex) {
                RuntimeLogger.LOGGER.error("Cannot load plugin: " + plugin.getClass().getName(), (Throwable)ex);
            }
        }
        return pluginModules;
    }

    protected void startPluginModules(List<Module> pluginModules) {
        for (Module module : pluginModules) {
            try {
                module.start();
            }
            catch (ModuleException ex) {
                RuntimeLogger.LOGGER.error("Cannot start plugin: " + module, (Throwable)ex);
            }
        }
    }

    protected void loadInitialConfigurations(ModuleContext syscontext) {
        String configs = (String)this.getProperty("org.jboss.gravia.runtime.configurations.dir");
        if (configs != null) {
            File configsDir = Paths.get(configs, new String[0]).toFile();
            if (configsDir.isDirectory()) {
                this.initConfigurationAdmin(syscontext, configsDir.getAbsoluteFile());
            } else {
                RuntimeLogger.LOGGER.warn("Invalid configuration directory: {}", (Object)configsDir);
            }
        }
    }

    protected AbstractModule createModule(ClassLoader classLoader, Resource resource, Dictionary<String, String> headers, Attachable context) {
        this.assertNoShutdown();
        AbstractModule module = resource != null && resource.getIdentity().equals((Object)this.getSystemIdentity()) ? new SystemModule(this, classLoader, resource, headers) : new EmbeddedModule(this, classLoader, resource, headers);
        return module;
    }

    protected ModuleEntriesProvider getDefaultEntriesProvider(Module module, Attachable context) {
        return new ClassLoaderEntriesProvider(module);
    }

    public <A> A adapt(Class<A> type) {
        Object result = super.adapt(type);
        if (result == null) {
            if (type.isAssignableFrom(RuntimeServicesManager.class)) {
                result = this.serviceManager;
            } else if (type.isAssignableFrom(RuntimeStorageHandler.class)) {
                result = this.storageHandler;
            }
        }
        return (A)result;
    }

    protected void uninstallModule(Module module) {
        super.uninstallModule(module);
    }

    protected void doShutdown() {
        super.doShutdown();
        for (ServiceRegistration<?> sreg : this.systemServices) {
            sreg.unregister();
        }
    }

    private MBeanServer findOrCreateMBeanServer() {
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() == 1) {
            MBeanServer mbeanServer = serverArr.get(0);
            RuntimeLogger.LOGGER.debug("Found MBeanServer: {}", (Object)mbeanServer.getDefaultDomain());
            return mbeanServer;
        }
        if (serverArr.size() > 1) {
            RuntimeLogger.LOGGER.info("Multiple MBeanServer instances: {}", serverArr);
        }
        RuntimeLogger.LOGGER.debug("Using the platform MBeanServer");
        return ManagementFactory.getPlatformMBeanServer();
    }

    private void initConfigurationAdmin(ModuleContext syscontext, File configsDir) {
        IllegalArgumentAssertion.assertTrue((Boolean)configsDir.isDirectory(), (String)("Invalid configuration directory: " + configsDir));
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)ServiceLocator.getRequiredService(ConfigurationAdmin.class);
        RuntimeLogger.LOGGER.info("Loading ConfigurationAdmin content from: {}", (Object)configsDir);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".cfg");
            }
        };
        for (String name : configsDir.list(filter)) {
            boolean factoryConfig = false;
            String pid = name.substring(0, name.length() - 4);
            if (pid.contains("-")) {
                factoryConfig = true;
                pid = pid.substring(0, pid.indexOf("-"));
                RuntimeLogger.LOGGER.info("Loading factory configuration: {}", (Object)pid);
            } else {
                RuntimeLogger.LOGGER.info("Loading configuration: {}", (Object)pid);
            }
            try {
                FileInputStream fis = new FileInputStream(new File(configsDir, name));
                Properties props = new Properties();
                props.load(fis);
                fis.close();
                Configuration config = factoryConfig ? configAdmin.createFactoryConfiguration(pid, null) : configAdmin.getConfiguration(pid, null);
                config.update((Dictionary)props);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

