/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.osgi.internal;

import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import org.jboss.gravia.resource.DictionaryResourceBuilder;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleException;
import org.jboss.gravia.runtime.osgi.internal.ModuleAdaptor;
import org.jboss.gravia.runtime.spi.AbstractModule;
import org.jboss.gravia.runtime.spi.AbstractRuntime;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTracker;

public final class OSGiRuntime
extends AbstractRuntime {
    private final BundleContext syscontext;
    private final BundleTracker<Bundle> tracker;

    public OSGiRuntime(BundleContext syscontext, PropertiesProvider propertiesProvider) {
        super(propertiesProvider);
        this.syscontext = syscontext;
        this.tracker = new BundleTracker<Bundle>(syscontext, 60, null){

            public Bundle addingBundle(Bundle bundle, BundleEvent event) {
                super.addingBundle(bundle, event);
                BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                ClassLoader classLoader = wiring != null ? wiring.getClassLoader() : null;
                DictionaryResourceBuilder resBuilder = new DictionaryResourceBuilder().load(bundle.getHeaders());
                if (classLoader != null && resBuilder.isValid()) {
                    try {
                        OSGiRuntime.this.installModule(classLoader, bundle.getHeaders());
                    }
                    catch (ModuleException ex) {
                        AbstractRuntime.LOGGER.errorf("Cannot install module from: %s", (Object)bundle);
                    }
                }
                return bundle;
            }

            public void remove(Bundle bundle) {
                Module module = OSGiRuntime.this.getModule(bundle.getBundleId());
                if (module != null) {
                    module.uninstall();
                }
                super.remove(bundle);
            }
        };
    }

    public void init() {
        this.tracker.open();
    }

    public AbstractModule createModule(ClassLoader classLoader, Resource resource, Dictionary<String, String> headers) {
        return new ModuleAdaptor(this, classLoader, resource, headers);
    }

    public ModuleEntriesProvider getModuleEntriesProvider(Module module) {
        return new OSGiModuleEntriesProvider(module);
    }

    protected void uninstallModule(Module module) {
        super.uninstallModule(module);
    }

    private class OSGiModuleEntriesProvider
    implements ModuleEntriesProvider {
        private final Module module;

        OSGiModuleEntriesProvider(Module module) {
            this.module = module;
        }

        public Enumeration<String> getEntryPaths(String path) {
            Bundle bundle = OSGiRuntime.this.syscontext.getBundle(this.module.getModuleId());
            return bundle.getEntryPaths(path);
        }

        public URL getEntry(String path) {
            Bundle bundle = OSGiRuntime.this.syscontext.getBundle(this.module.getModuleId());
            return bundle.getEntry(path);
        }

        public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
            Bundle bundle = OSGiRuntime.this.syscontext.getBundle(this.module.getModuleId());
            return bundle.findEntries(path, filePattern, recurse);
        }
    }
}

