/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gwt.circuit.sample.wardrobe.stores;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.gwt.circuit.Action;
import org.jboss.gwt.circuit.Agreement;
import org.jboss.gwt.circuit.ChangeSupport;
import org.jboss.gwt.circuit.Dispatcher;
import org.jboss.gwt.circuit.StoreCallback;
import org.jboss.gwt.circuit.sample.wardrobe.actions.Dress;
import org.jboss.gwt.circuit.sample.wardrobe.actions.Undress;
import org.jboss.gwt.circuit.sample.wardrobe.stores.CoatStore;
import org.jboss.gwt.circuit.sample.wardrobe.stores.PulloverStore;
import org.jboss.gwt.circuit.sample.wardrobe.stores.UndershirtStore;

@ApplicationScoped
public class PulloverStoreAdapter {
    private final PulloverStore delegate;

    @Inject
    public PulloverStoreAdapter(final PulloverStore delegate, Dispatcher dispatcher) {
        this.delegate = delegate;
        dispatcher.register(PulloverStore.class, new StoreCallback(){

            public Agreement voteFor(Action action) {
                if (action instanceof Dress) {
                    return new Agreement(true, new Class[]{UndershirtStore.class});
                }
                if (action instanceof Undress) {
                    return new Agreement(true, new Class[]{CoatStore.class});
                }
                return Agreement.NONE;
            }

            public void complete(Action action, Dispatcher.Channel channel) {
                if (action instanceof Dress) {
                    delegate.dress(channel);
                } else if (action instanceof Undress) {
                    delegate.undress(channel);
                } else {
                    System.out.println("WARN: Unmatched action " + action.getClass().getName() + " in store " + delegate.getClass());
                    channel.ack();
                }
            }

            public void signalChange(Action action) {
                System.out.println("WARN: Cannot signal change event: " + PulloverStore.class.getName() + " does not extend " + ChangeSupport.class.getName());
            }
        });
    }
}

