/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gwt.circuit.sample.wardrobe.stores;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.gwt.circuit.Action;
import org.jboss.gwt.circuit.Agreement;
import org.jboss.gwt.circuit.ChangeSupport;
import org.jboss.gwt.circuit.Dispatcher;
import org.jboss.gwt.circuit.StoreCallback;
import org.jboss.gwt.circuit.sample.wardrobe.actions.Dress;
import org.jboss.gwt.circuit.sample.wardrobe.actions.Undress;
import org.jboss.gwt.circuit.sample.wardrobe.stores.TrousersStore;
import org.jboss.gwt.circuit.sample.wardrobe.stores.UnderwearStore;

@ApplicationScoped
public class UnderwearStoreAdapter {
    private final UnderwearStore delegate;

    @Inject
    public UnderwearStoreAdapter(final UnderwearStore delegate, Dispatcher dispatcher) {
        this.delegate = delegate;
        dispatcher.register(UnderwearStore.class, new StoreCallback(){

            public Agreement voteFor(Action action) {
                if (action instanceof Dress) {
                    return new Agreement(true, new Class[0]);
                }
                if (action instanceof Undress) {
                    return new Agreement(true, new Class[]{TrousersStore.class});
                }
                return Agreement.NONE;
            }

            public void complete(Action action, Dispatcher.Channel channel) {
                if (action instanceof Dress) {
                    delegate.dress(channel);
                } else if (action instanceof Undress) {
                    delegate.undress(channel);
                } else {
                    channel.nack("Warning: Unmatched action type " + action.getClass().getName() + " in store " + delegate.getClass());
                }
            }

            public void signalChange(Action action) {
                System.out.println("WARN: Cannot signal change event: " + UnderwearStore.class.getName() + " does not extend " + ChangeSupport.class.getName());
            }
        });
    }
}

