/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.gwt.elemento.sample.builder.client;

enum Filter {
    ALL("#/"), ACTIVE("#/active"), COMPLETED("#/completed");

    private final String fragment;

    Filter(final String fragment) {
        this.fragment = fragment;
    }

    String fragment() {
        return fragment;
    }

    String filter() {
        return name().toLowerCase();
    }

    public static Filter parseToken(final String token) {
        if (token == null) {
            return ALL;
        } else {
            switch (token) {
                case "/":
                    return ALL;
                case "/active":
                    return ACTIVE;
                case "/completed":
                    return COMPLETED;
                default:
                    return ALL;
            }
        }
    }
}
