/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.promise.Promise;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.lang.Void;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface Cache {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface AddAllRequestsArrayUnionType {
    @JsOverlay
    static AddAllRequestsArrayUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Request asRequest() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isRequest() {
      return (Object) this instanceof Request;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface AddRequestUnionType {
    @JsOverlay
    static AddRequestUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Request asRequest() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isRequest() {
      return (Object) this instanceof Request;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface DeleteRequestUnionType {
    @JsOverlay
    static DeleteRequestUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Request asRequest() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isRequest() {
      return (Object) this instanceof Request;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface KeysRequestUnionType {
    @JsOverlay
    static KeysRequestUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Request asRequest() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isRequest() {
      return (Object) this instanceof Request;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface MatchAllRequestUnionType {
    @JsOverlay
    static MatchAllRequestUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Request asRequest() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isRequest() {
      return (Object) this instanceof Request;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface MatchRequestUnionType {
    @JsOverlay
    static MatchRequestUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Request asRequest() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isRequest() {
      return (Object) this instanceof Request;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface PutRequestUnionType {
    @JsOverlay
    static PutRequestUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Request asRequest() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isRequest() {
      return (Object) this instanceof Request;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  Promise<Void> add(AddRequestUnionType request);

  @JsOverlay
  default Promise<Void> add(Request request) {
    return add(Js.<AddRequestUnionType>uncheckedCast(request));
  }

  @JsOverlay
  default Promise<Void> add(String request) {
    return add(Js.<AddRequestUnionType>uncheckedCast(request));
  }

  Promise<Void> addAll(AddAllRequestsArrayUnionType[] requests);

  Promise<Boolean> delete(DeleteRequestUnionType request, CacheQueryOptions options);

  Promise<Boolean> delete(DeleteRequestUnionType request);

  @JsOverlay
  default Promise<Boolean> delete(Request request, CacheQueryOptions options) {
    return delete(Js.<DeleteRequestUnionType>uncheckedCast(request), options);
  }

  @JsOverlay
  default Promise<Boolean> delete(Request request) {
    return delete(Js.<DeleteRequestUnionType>uncheckedCast(request));
  }

  @JsOverlay
  default Promise<Boolean> delete(String request, CacheQueryOptions options) {
    return delete(Js.<DeleteRequestUnionType>uncheckedCast(request), options);
  }

  @JsOverlay
  default Promise<Boolean> delete(String request) {
    return delete(Js.<DeleteRequestUnionType>uncheckedCast(request));
  }

  Promise<Request[]> keys();

  Promise<Request[]> keys(KeysRequestUnionType request, CacheQueryOptions options);

  Promise<Request[]> keys(KeysRequestUnionType request);

  @JsOverlay
  default Promise<Request[]> keys(Request request, CacheQueryOptions options) {
    return keys(Js.<KeysRequestUnionType>uncheckedCast(request), options);
  }

  @JsOverlay
  default Promise<Request[]> keys(Request request) {
    return keys(Js.<KeysRequestUnionType>uncheckedCast(request));
  }

  @JsOverlay
  default Promise<Request[]> keys(String request, CacheQueryOptions options) {
    return keys(Js.<KeysRequestUnionType>uncheckedCast(request), options);
  }

  @JsOverlay
  default Promise<Request[]> keys(String request) {
    return keys(Js.<KeysRequestUnionType>uncheckedCast(request));
  }

  Promise<Response> match(MatchRequestUnionType request, CacheQueryOptions options);

  Promise<Response> match(MatchRequestUnionType request);

  @JsOverlay
  default Promise<Response> match(Request request, CacheQueryOptions options) {
    return match(Js.<MatchRequestUnionType>uncheckedCast(request), options);
  }

  @JsOverlay
  default Promise<Response> match(Request request) {
    return match(Js.<MatchRequestUnionType>uncheckedCast(request));
  }

  @JsOverlay
  default Promise<Response> match(String request, CacheQueryOptions options) {
    return match(Js.<MatchRequestUnionType>uncheckedCast(request), options);
  }

  @JsOverlay
  default Promise<Response> match(String request) {
    return match(Js.<MatchRequestUnionType>uncheckedCast(request));
  }

  Promise<Response[]> matchAll();

  Promise<Response[]> matchAll(MatchAllRequestUnionType request, CacheQueryOptions options);

  Promise<Response[]> matchAll(MatchAllRequestUnionType request);

  @JsOverlay
  default Promise<Response[]> matchAll(Request request, CacheQueryOptions options) {
    return matchAll(Js.<MatchAllRequestUnionType>uncheckedCast(request), options);
  }

  @JsOverlay
  default Promise<Response[]> matchAll(Request request) {
    return matchAll(Js.<MatchAllRequestUnionType>uncheckedCast(request));
  }

  @JsOverlay
  default Promise<Response[]> matchAll(String request, CacheQueryOptions options) {
    return matchAll(Js.<MatchAllRequestUnionType>uncheckedCast(request), options);
  }

  @JsOverlay
  default Promise<Response[]> matchAll(String request) {
    return matchAll(Js.<MatchAllRequestUnionType>uncheckedCast(request));
  }

  Promise<Void> put(PutRequestUnionType request, Response response);

  @JsOverlay
  default Promise<Void> put(Request request, Response response) {
    return put(Js.<PutRequestUnionType>uncheckedCast(request), response);
  }

  @JsOverlay
  default Promise<Void> put(String request, Response response) {
    return put(Js.<PutRequestUnionType>uncheckedCast(request), response);
  }
}
