/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.core;

import java.lang.Double;
import java.lang.Object;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Int16Array extends TypedArray {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ConstructorLengthUnionType {
    @JsOverlay
    static ConstructorLengthUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ArrayBuffer asArrayBuffer() {
      return Js.cast(this);
    }

    @JsOverlay
    default ArrayBufferView asArrayBufferView() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.castToDouble(this);
    }

    @JsOverlay
    default double[] asDoubleArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isArrayBuffer() {
      return (Object) this instanceof ArrayBuffer;
    }

    @JsOverlay
    default boolean isArrayBufferView() {
      return (Object) this instanceof ArrayBufferView;
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isDoubleArray() {
      return (Object) this instanceof Object[];
    }
  }

  @JsFunction
  public interface FromMapCallbackFn {
    double onInvoke(double p0);
  }

  @JsOverlay public static final double BYTES_PER_ELEMENT = Int16Array__Constants.BYTES_PER_ELEMENT;

  public static native <S> Int16Array from(double[] source, FromMapCallbackFn mapFn, S this_);

  public static native Int16Array from(double[] source, FromMapCallbackFn mapFn);

  public static native Int16Array from(double[] source);

  public static native Int16Array of(double... var_args);

  public Int16Array(ArrayBuffer length, double byteOffset, double length0) {}

  public Int16Array(ArrayBuffer length, double byteOffset) {}

  public Int16Array(ArrayBuffer length) {}

  public Int16Array(ArrayBufferView length, double byteOffset, double length0) {}

  public Int16Array(ArrayBufferView length, double byteOffset) {}

  public Int16Array(ArrayBufferView length) {}

  public Int16Array(ConstructorLengthUnionType length, double byteOffset, double length0) {}

  public Int16Array(ConstructorLengthUnionType length, double byteOffset) {}

  public Int16Array(ConstructorLengthUnionType length) {}

  public Int16Array(double length, double byteOffset, double length0) {}

  public Int16Array(double[] length, double byteOffset, double length0) {}

  public Int16Array(double length, double byteOffset) {}

  public Int16Array(double[] length, double byteOffset) {}

  public Int16Array(double length) {}

  public Int16Array(double[] length) {}
}
