/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import java.lang.String;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface MediaTrackConstraintSetInterface_ {
  @JsProperty
  String getChromeMediaSource();

  @JsProperty
  double getMaxAspectRatio();

  @JsProperty
  double getMaxFrameRate();

  @JsProperty
  double getMaxHeight();

  @JsProperty
  double getMaxWidth();

  @JsProperty
  double getMinAspectRatio();

  @JsProperty
  double getMinFrameRate();

  @JsProperty
  double getMinHeight();

  @JsProperty
  double getMinWidth();

  @JsProperty
  String getSourceId();

  @JsProperty
  boolean isEchoCancellation();

  @JsProperty
  void setChromeMediaSource(String chromeMediaSource);

  @JsProperty
  void setEchoCancellation(boolean echoCancellation);

  @JsProperty
  void setMaxAspectRatio(double maxAspectRatio);

  @JsProperty
  void setMaxFrameRate(double maxFrameRate);

  @JsProperty
  void setMaxHeight(double maxHeight);

  @JsProperty
  void setMaxWidth(double maxWidth);

  @JsProperty
  void setMinAspectRatio(double minAspectRatio);

  @JsProperty
  void setMinFrameRate(double minFrameRate);

  @JsProperty
  void setMinHeight(double minHeight);

  @JsProperty
  void setMinWidth(double minWidth);

  @JsProperty
  void setSourceId(String sourceId);
}
