/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.injector.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import org.jboss.injection.injector.util.FieldInjectionPoint;
import org.jboss.injection.injector.util.InjectionPoint;
import org.jboss.injection.injector.util.MethodInjectionPoint;
import org.jboss.injection.injector.util.NoSuchPropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionPointFactory {
    static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    public static InjectionPoint create(Class<?> cls, String property) throws NoSuchPropertyException {
        String writeMethodName = "set" + InjectionPointFactory.capitalize(property);
        Method writeMethod = InjectionPointFactory.findWriteMethod(cls, writeMethodName);
        if (writeMethod != null) {
            return new MethodInjectionPoint(writeMethod);
        }
        try {
            Field field = cls.getDeclaredField(property);
            return new FieldInjectionPoint(field);
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchPropertyException("No such property " + property + " on " + cls, e);
        }
    }

    private static Method findWriteMethod(Class<?> cls, String methodName) {
        for (Method m : cls.getDeclaredMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        return null;
    }
}

