/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.config.builder;

import java.util.Properties;
import org.switchyard.component.common.knowledge.config.builder.KnowledgeBuilder;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.config.model.property.PropertiesModel;

public class PropertiesBuilder
extends KnowledgeBuilder {
    private Properties _defaultProperties;
    private Properties _modelProperties;
    private Properties _overrideProperties;

    public PropertiesBuilder() {
    }

    public PropertiesBuilder(PropertiesModel propertiesModel) {
        this.setModelProperties(propertiesModel);
    }

    public PropertiesBuilder setDefaultProperties(Properties defaultProperties) {
        this._defaultProperties = defaultProperties;
        return this;
    }

    public PropertiesBuilder setModelProperties(PropertiesModel propertiesModel) {
        this._modelProperties = propertiesModel != null ? propertiesModel.toProperties() : null;
        return this;
    }

    public PropertiesBuilder setOverrideProperties(Properties overrideProperties) {
        this._overrideProperties = overrideProperties;
        return this;
    }

    public Properties build() {
        Properties buildProperties = new Properties();
        this.merge(this._defaultProperties, buildProperties);
        this.merge(this._modelProperties, buildProperties);
        this.merge(this._overrideProperties, buildProperties);
        return buildProperties;
    }

    private void merge(Properties fromProperties, Properties toProperties) {
        if (fromProperties != null && toProperties != null) {
            for (Object key : fromProperties.keySet()) {
                String name = (String)key;
                String value = fromProperties.getProperty(name);
                if (value == null) continue;
                toProperties.put(name, value);
            }
        }
    }

    public static PropertiesBuilder builder(KnowledgeComponentImplementationModel implementationModel) {
        PropertiesModel propertiesModel = null;
        if (implementationModel != null) {
            propertiesModel = implementationModel.getProperties();
        }
        return new PropertiesBuilder(propertiesModel);
    }
}

