/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.config.builder;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.remote.client.api.RemoteJmsRuntimeEngineBuilder;
import org.kie.remote.client.api.RemoteRestRuntimeEngineBuilder;
import org.kie.remote.client.api.RemoteRuntimeEngineBuilder;
import org.kie.remote.client.jaxb.AcceptedClientCommands;
import org.kie.services.client.api.RemoteRuntimeEngineFactory;
import org.kie.services.client.api.command.RemoteConfiguration;
import org.kie.services.client.api.command.RemoteRuntimeEngine;
import org.switchyard.common.type.reflect.FieldAccess;
import org.switchyard.component.common.knowledge.config.builder.KnowledgeBuilder;
import org.switchyard.component.common.knowledge.config.model.ExtraJaxbClassModel;
import org.switchyard.component.common.knowledge.config.model.ExtraJaxbClassesModel;
import org.switchyard.component.common.knowledge.config.model.RemoteJmsModel;
import org.switchyard.component.common.knowledge.config.model.RemoteModel;
import org.switchyard.component.common.knowledge.config.model.RemoteRestModel;

public class RemoteConfigurationBuilder
extends KnowledgeBuilder {
    private static Set<Class<?>> acceptedCommands = new HashSet();
    private final RemoteConfiguration _remoteConfiguration;

    public RemoteConfigurationBuilder(ClassLoader classLoader, RemoteModel remoteModel) {
        super(classLoader);
        this._remoteConfiguration = this.buildRemoteConfiguration(remoteModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteConfiguration buildRemoteConfiguration(RemoteModel remoteModel) {
        RemoteJmsRuntimeEngineBuilder builder;
        RuntimeEngine engine = null;
        if (remoteModel instanceof RemoteJmsModel) {
            builder = RemoteRuntimeEngineFactory.newJmsBuilder();
            InitialContext ctx = this.configRemoteJms(builder, (RemoteJmsModel)remoteModel);
            try {
                engine = builder.build();
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Exception e) {
                        e.getMessage();
                    }
                }
            }
        }
        if (remoteModel instanceof RemoteRestModel) {
            builder = RemoteRuntimeEngineFactory.newRestBuilder();
            this.configRemoteRest((RemoteRestRuntimeEngineBuilder)builder, (RemoteRestModel)remoteModel);
            engine = builder.build();
        }
        RemoteConfiguration config = null;
        if (engine instanceof RemoteRuntimeEngine) {
            FieldAccess configAccess = new FieldAccess(RemoteRuntimeEngine.class, "config");
            config = configAccess.isReadable() ? (RemoteConfiguration)configAccess.read((Object)engine) : null;
        }
        return config;
    }

    private InitialContext configRemoteJms(RemoteJmsRuntimeEngineBuilder builder, RemoteJmsModel model) {
        String truststoreLocation;
        String truststorePassword;
        String keystoreLocation;
        this.configRemote((RemoteRuntimeEngineBuilder<?, ?>)builder, model);
        InitialContext ctx = null;
        String hostName = model.getHostName();
        if (hostName != null) {
            builder.addHostName(hostName);
            try {
                String password;
                Properties props = new Properties();
                props.setProperty("java.naming.factory.initial", "org.jboss.naming.remote.client.InitialContextFactory");
                Integer remotingPort = model.getRemotingPort();
                if (remotingPort == null) {
                    remotingPort = 4447;
                }
                props.setProperty("java.naming.provider.url", "remote://" + hostName + ":" + remotingPort);
                String userName = model.getUserName();
                if (userName != null) {
                    props.setProperty("java.naming.security.principal", userName);
                }
                if ((password = model.getPassword()) != null) {
                    props.setProperty("java.naming.security.credentials", password);
                }
                ctx = new InitialContext(props);
                builder.addRemoteInitialContext(ctx);
            }
            catch (NamingException ne) {
                throw new RuntimeException(ne);
            }
        }
        try {
            ctx = new InitialContext();
            builder.addRemoteInitialContext(ctx);
        }
        catch (NamingException ne) {
            throw new RuntimeException(ne);
        }
        Integer messagingPort = model.getMessagingPort();
        if (messagingPort == null) {
            messagingPort = 5455;
        }
        builder.addJmsConnectorPort(messagingPort.intValue());
        builder.useSsl(model.isUseSsl());
        String keystorePassword = model.getKeystorePassword();
        if (keystorePassword != null) {
            builder.addKeystorePassword(keystorePassword);
            builder.addTruststorePassword(keystorePassword);
        }
        if ((keystoreLocation = model.getKeystoreLocation()) != null) {
            builder.addKeystoreLocation(keystoreLocation);
            builder.addTruststoreLocation(keystoreLocation);
        }
        if ((truststorePassword = model.getTruststorePassword()) != null) {
            builder.addTruststorePassword(truststorePassword);
        }
        if ((truststoreLocation = model.getTruststoreLocation()) != null) {
            builder.addTruststoreLocation(truststoreLocation);
        }
        return ctx;
    }

    private void configRemoteRest(RemoteRestRuntimeEngineBuilder builder, RemoteRestModel model) {
        this.configRemote((RemoteRuntimeEngineBuilder<?, ?>)builder, model);
        try {
            builder.addUrl(new URL(model.getUrl()));
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue);
        }
        builder.useFormBasedAuth(model.isUseFormBasedAuth());
    }

    private void configRemote(RemoteRuntimeEngineBuilder<?, ?> builder, RemoteModel model) {
        ExtraJaxbClassesModel extraJaxbClasses;
        Integer timeout;
        String password;
        builder.addDeploymentId(model.getDeploymentId());
        String userName = model.getUserName();
        if (userName != null) {
            builder.addUserName(userName);
        }
        if ((password = model.getPassword()) != null) {
            builder.addPassword(password);
        }
        if ((timeout = model.getTimeout()) != null) {
            builder.addTimeout(timeout.intValue());
        }
        if ((extraJaxbClasses = model.getExtraJaxbClasses()) != null) {
            LinkedHashSet clazzes = new LinkedHashSet();
            ClassLoader loader = this.getClassLoader();
            for (ExtraJaxbClassModel extraJaxbClass : extraJaxbClasses.getExtraJaxbClasses()) {
                Class<?> clazz = extraJaxbClass.getClazz(loader);
                if (clazz == null) continue;
                clazzes.add(clazz);
            }
            int cs = clazzes.size();
            if (cs > 0) {
                builder.addExtraJaxbClasses(clazzes.toArray(new Class[cs]));
            }
        }
        builder.addExtraJaxbClasses(acceptedCommands.toArray(new Class[acceptedCommands.size()]));
    }

    public RemoteConfiguration build() {
        return this._remoteConfiguration.clone();
    }

    static {
        FieldAccess access = new FieldAccess(AcceptedClientCommands.class, "acceptedCommands");
        acceptedCommands.addAll((Collection)access.read(null));
        acceptedCommands.add(BatchExecutionCommandImpl.class);
        acceptedCommands = Collections.unmodifiableSet(acceptedCommands);
        access.write(null, acceptedCommands);
    }
}

