/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.operation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.switchyard.component.common.knowledge.expression.ExpressionMapping;
import org.switchyard.component.common.knowledge.operation.KnowledgeOperationType;

public class KnowledgeOperation {
    private final KnowledgeOperationType _type;
    private final String _eventId;
    private final List<ExpressionMapping> _globalExpressionMappings = new ArrayList<ExpressionMapping>();
    private final List<ExpressionMapping> _inputExpressionMappings = new ArrayList<ExpressionMapping>();
    private final List<ExpressionMapping> _outputExpressionMappings = new ArrayList<ExpressionMapping>();
    private final List<ExpressionMapping> _faultExpressionMappings = new ArrayList<ExpressionMapping>();

    public KnowledgeOperation(KnowledgeOperationType type) {
        this(type, null);
    }

    public KnowledgeOperation(KnowledgeOperationType type, String eventId) {
        this._type = type;
        this._eventId = eventId;
    }

    public KnowledgeOperationType getType() {
        return this._type;
    }

    public String getEventId() {
        return this._eventId;
    }

    public List<ExpressionMapping> getGlobalExpressionMappings() {
        return this._globalExpressionMappings;
    }

    public List<ExpressionMapping> getInputExpressionMappings() {
        return this._inputExpressionMappings;
    }

    public List<ExpressionMapping> getInputOnlyExpressionMappings() {
        LinkedList<ExpressionMapping> list = new LinkedList<ExpressionMapping>();
        for (ExpressionMapping em : this._inputExpressionMappings) {
            if (em.getOutput() != null) continue;
            list.add(em);
        }
        return list;
    }

    public Map<String, ExpressionMapping> getInputOutputExpressionMappings() {
        LinkedHashMap<String, ExpressionMapping> map = new LinkedHashMap<String, ExpressionMapping>();
        for (ExpressionMapping em : this._inputExpressionMappings) {
            String output = em.getOutput();
            if (output == null) continue;
            if (map.containsKey(output)) {
                throw new IllegalArgumentException("duplicate input/output variable [" + output + "] not allowed");
            }
            map.put(output, em);
        }
        return map;
    }

    public List<ExpressionMapping> getOutputExpressionMappings() {
        return this._outputExpressionMappings;
    }

    public List<ExpressionMapping> getFaultExpressionMappings() {
        return this._faultExpressionMappings;
    }
}

