/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.config.builder;

import java.util.ArrayList;
import java.util.List;
import org.kie.api.KieServices;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.logger.KieLoggers;
import org.kie.api.logger.KieRuntimeLogger;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.common.knowledge.LoggerType;
import org.switchyard.component.common.knowledge.config.builder.KnowledgeBuilder;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.LoggerModel;
import org.switchyard.component.common.knowledge.config.model.LoggersModel;

public class LoggerBuilder
extends KnowledgeBuilder {
    private LoggerType _loggerType;
    private String _log;
    private Integer _interval;

    public LoggerBuilder(ClassLoader classLoader, LoggerModel loggerModel) {
        super(classLoader);
        if (loggerModel != null) {
            this._loggerType = loggerModel.getType();
            this._log = Strings.trimToNull((String)loggerModel.getLog());
            this._interval = loggerModel.getInterval();
        }
        if (this._loggerType == null) {
            this._loggerType = LoggerType.THREADED_FILE;
        }
        if (this._log == null) {
            this._log = "event";
        }
        if (this._interval == null) {
            this._interval = 1000;
        }
    }

    public KieRuntimeLogger build(KieRuntimeEventManager runtimeEventManager) {
        KieRuntimeLogger logger2 = null;
        if (this._loggerType != null && runtimeEventManager != null) {
            KieLoggers loggers = KieServices.Factory.get().getLoggers();
            switch (this._loggerType) {
                case CONSOLE: {
                    logger2 = loggers.newConsoleLogger(runtimeEventManager);
                    break;
                }
                case FILE: {
                    logger2 = loggers.newFileLogger(runtimeEventManager, this._log);
                    break;
                }
                case THREADED_FILE: {
                    logger2 = loggers.newThreadedFileLogger(runtimeEventManager, this._log, this._interval.intValue());
                }
            }
        }
        return logger2;
    }

    public static List<LoggerBuilder> builders(ClassLoader classLoader, KnowledgeComponentImplementationModel implementationModel) {
        LoggersModel loggersModel;
        ArrayList<LoggerBuilder> builders = new ArrayList<LoggerBuilder>();
        if (implementationModel != null && (loggersModel = implementationModel.getLoggers()) != null) {
            for (LoggerModel loggerModel : loggersModel.getLoggers()) {
                if (loggerModel == null) continue;
                builders.add(new LoggerBuilder(classLoader, loggerModel));
            }
        }
        return builders;
    }
}

