/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.config.manifest;

import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.switchyard.component.common.knowledge.CommonKnowledgeMessages;
import org.switchyard.component.common.knowledge.config.manifest.Manifest;

public final class ContainerManifest
extends Manifest {
    private final String _baseName;
    private final ReleaseId _releaseId;
    private final boolean _scan;
    private final Long _scanInterval;
    private final String _sessionName;
    private KieContainer _kieContainer;

    public ContainerManifest() {
        this(null, (ReleaseId)null, false, null, null);
    }

    public ContainerManifest(String baseName, String releaseId, boolean scan, Long scanInterval, String sessionName) {
        this(baseName, ContainerManifest.toReleaseId(releaseId), scan, scanInterval, sessionName);
    }

    public ContainerManifest(String baseName, ReleaseId releaseId, boolean scan, Long scanInterval, String sessionName) {
        long si;
        this._baseName = baseName;
        this._releaseId = releaseId;
        this._scan = scan;
        if (scanInterval == null) {
            scanInterval = 60000L;
        }
        if ((si = scanInterval.longValue()) < 1L) {
            throw CommonKnowledgeMessages.MESSAGES.containerScanIntervalMustBePositive();
        }
        this._scanInterval = scanInterval;
        this._sessionName = sessionName;
    }

    public String getBaseName() {
        return this._baseName;
    }

    public ReleaseId getReleaseId() {
        return this._releaseId;
    }

    public boolean isScan() {
        return this._scan;
    }

    public Long getScanInterval() {
        return this._scanInterval;
    }

    public String getSessionName() {
        return this._sessionName;
    }

    public KieContainer getKieContainer() {
        return this._kieContainer;
    }

    public void setKieContainer(KieContainer kieContainer) {
        this._kieContainer = kieContainer;
    }

    public static ContainerManifest removeFromEnvironment(Environment environment) {
        return Manifest.removeFromEnvironment(environment, ContainerManifest.class);
    }

    public static ReleaseId toReleaseId(String releaseId) {
        if (releaseId != null) {
            String[] gav = releaseId.split(":", 3);
            String groupId = gav.length > 0 ? gav[0] : null;
            String artifactId = gav.length > 1 ? gav[1] : null;
            String version = gav.length > 2 ? gav[2] : null;
            return KieServices.Factory.get().newReleaseId(groupId, artifactId, version);
        }
        return null;
    }
}

