/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.runtime;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import org.kie.api.runtime.manager.RuntimeManager;
import org.switchyard.ServiceDomain;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.knowledge.config.builder.ChannelBuilder;
import org.switchyard.component.common.knowledge.config.builder.LoggerBuilder;
import org.switchyard.component.common.knowledge.config.builder.RuntimeManagerBuilder;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.runtime.KnowledgeRuntimeManager;
import org.switchyard.component.common.knowledge.runtime.KnowledgeRuntimeManagerType;
import org.switchyard.deploy.ServiceDomainManager;

public class KnowledgeRuntimeManagerFactory {
    private static final AtomicInteger IDENTIFIER_COUNT = new AtomicInteger();
    private final ClassLoader _classLoader;
    private final RuntimeManagerBuilder _runtimeManagerBuilder;
    private final List<ChannelBuilder> _channelBuilders;
    private final List<LoggerBuilder> _loggerBuilders;
    private final boolean _persistent;
    private final QName _serviceDomainName;
    private final QName _serviceName;
    private final String _identifierRoot;

    public KnowledgeRuntimeManagerFactory(ClassLoader classLoader, ServiceDomain serviceDomain, QName serviceName, KnowledgeComponentImplementationModel implementationModel) {
        this._classLoader = classLoader;
        this._runtimeManagerBuilder = new RuntimeManagerBuilder(classLoader, serviceDomain, implementationModel);
        this._persistent = implementationModel.isPersistent();
        this._channelBuilders = ChannelBuilder.builders(classLoader, serviceDomain, implementationModel);
        this._loggerBuilders = LoggerBuilder.builders(classLoader, implementationModel);
        this._serviceDomainName = serviceDomain.getName() != null ? serviceDomain.getName() : ServiceDomainManager.ROOT_DOMAIN;
        this._serviceName = serviceName;
        this._identifierRoot = this._serviceDomainName.toString() + "/" + this._serviceName.toString() + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KnowledgeRuntimeManager newRuntimeManager(KnowledgeRuntimeManagerType type) {
        RuntimeManager runtimeManager;
        String identifier = this._identifierRoot + IDENTIFIER_COUNT.incrementAndGet();
        ClassLoader origTCCL = Classes.setTCCL((ClassLoader)this._classLoader);
        try {
            runtimeManager = this._runtimeManagerBuilder.build(type, identifier);
        }
        finally {
            Classes.setTCCL((ClassLoader)origTCCL);
        }
        return new KnowledgeRuntimeManager(this._classLoader, type, this._serviceDomainName, this._serviceName, runtimeManager, this._persistent, this._channelBuilders, this._loggerBuilders);
    }
}

