/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */ 
package org.jboss.profileservice.spi;

import java.io.Serializable;
import java.util.Map;

import org.jboss.virtual.VirtualFile;

/**
 * The profile deployment.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public interface ProfileDeployment extends Serializable
{

   /**
    * Get the deployment name
    * 
    * @return the name
    */
   String getName();
   
   /**
    * Get the root of the deployment
    * 
    * @return the root, or null if it's not a VFS based deployment
    */
   VirtualFile getRoot();
   
   /**
    * Get all attachments.
    * 
    * @return the attachments
    */
   Map<String, Object> getAttachments();
   
   /**
    * Get attachment
    * 
    * @param name the name of the attachment
    * @return the attachment or null if not present
    * 
    * @throws IllegalArgumentException for a null name
    */
   Object getAttachment(String name);
   
   /**
    * Add attachment
    *
    * @param name the name of the attachment
    * @param attachment the attachment
    * @return any previous attachment
    * 
    * @throws IllegalArgumentException for a null name or attachment
    */
   Object addAttachment(String name, Object attachment);
   
}

