/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.spi;

import java.io.Serializable;

public class ProfileKey
implements Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT = "default";
    private String domain;
    private String server;
    private String name;

    public ProfileKey(String name) {
        this(DEFAULT, DEFAULT, name);
    }

    public ProfileKey(String domain, String server, String name) {
        if (domain == null) {
            domain = DEFAULT;
        }
        this.domain = domain;
        if (server == null) {
            server = DEFAULT;
        }
        this.server = server;
        if (name == null) {
            name = DEFAULT;
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public boolean isDefaultKey() {
        return DEFAULT.equalsIgnoreCase(this.domain) && DEFAULT.equalsIgnoreCase(this.server) && DEFAULT.equalsIgnoreCase(this.name);
    }

    public int compareTo(Object o) {
        ProfileKey pk = (ProfileKey)o;
        int compareTo = this.domain.compareTo(pk.domain);
        if (compareTo == 0 && (compareTo = this.server.compareTo(pk.server)) == 0) {
            compareTo = this.name.compareTo(pk.name);
        }
        return compareTo;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        int hash = this.domain.hashCode() + this.server.hashCode() + this.name.hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder(super.toString());
        tmp.append('[');
        tmp.append("domain=");
        tmp.append(this.domain);
        tmp.append(",server=");
        tmp.append(this.server);
        tmp.append(",name=");
        tmp.append(this.name);
        tmp.append(']');
        return tmp.toString();
    }
}

