/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.deployers.spi.management.deploy;

import java.net.URL;

import org.jboss.profileservice.spi.ProfileKey;

/**
 * A representation of a top-level deployment id.
 * 
 * @author Scott.Stark@jboss.org
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision:$
 */
public interface DeploymentID
{
   /**
    * Get the names of the deployments.
    *
    * @return the deployment name
    */
   String[] getNames();
   
   /**
    * The target profile this deployment is
    * associated with.
    * 
    * @return the profile key.
    */
   ProfileKey getProfile();
   
   /**
    * Get the unique names of the deployments in the repository. Some DeploymentManager
    * operations like distribute produce an alternate unique name that differs
    * from the input name. In this case this method will provide the unique
    * names for the input names. Otherwise this returns the same value as
    * getNames.
    * 
    * @return the unique names of the deployments in the repository
    */
   String[] getRepositoryNames();
   
   /**
    * Set the unique names of the deployments in the repository.
    * @see #getRepositoryNames()
    * @param names - the unique names of the deployments in the repository
    */
   void setRepositoryNames(String[] names);

   /**
    * An optional content URL used for distribute/redeploy operations.
    * @return
    */
   URL getContentURL();

   /**
    * Do we copy content or jut ref it.
    * @return
    */
   boolean isCopyContent();

   /**
    * Get a description of the deployment
    *
    * @return the identifier
    */
   String getDescription();
}
