/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.deployers.spi.management;

import org.jboss.managed.api.RunState;
import org.jboss.metatype.api.values.MetaValue;

/**
 * A delegating runtime component dispatcher interface used by proxies for
 * ManagedProperty gets and ManagedOperation invokes.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @author Scott.Stark@jboss.org
 * @version $Revision: 90088 $
 */
public interface DelegatingComponentDispatcher
{
   /**
    * Get a property value from a runtime component
    * 
    * @param propID - the unique id associated with the ManagedProperty
    * @param componentName - runtime component name
    * @param propertyName - property name
    * @return wrapped MetaValue view of the property value
    */
   MetaValue get(Long propID, Object componentName, String propertyName);

   /**
    * Invoke an operation on a runtime component.
    * 
    * @param opID - the unique id associated with the ManagedOperation
    * @param componentName - runtime component name
    * @param methodName - the operation name
    * @param param - the wrapped parameters for the invocation
    * @return wrapped MetaValue view of the operation result
    */
   MetaValue invoke(Long opID, Object componentName, String methodName, MetaValue... param);
   
   /**
    * Get the current RunState of the component.
    * 
    * @param componentName - runtime component name
    * @return the run state
    */
   RunState updateRunState(Object componentName); 
}
